ORCA/M Asm65816 2.1.0

0001 56CC                       title 'QD Regions           GS ROM 3.0'
0002 56CC              ****************************************************************
0003 56CC              *                                                              *
0004 56CC              *              REGIONS                                         *
0005 56CC              *                                                              *
0006 56CC              ****************************************************************
0007 56CC
0008 56CC
0009 56CC              ****************************************************************
0010 56CC              *                                                              *
0011 56CC              *                   Copyright (C) 1985-1989                    *
0012 56CC              *                   All Rights Reserved                        *
0013 56CC              *                   Apple Computer, Inc.                       *
0014 56CC              *                                                              *
0015 56CC              ****************************************************************
0016 56CC
0017 56CC                       blanks off 
0018 56CC                       string asis 
0019 56CC
0020 56CC                       include 'all.macros' 
0021 56CC
0022 56CC                       include '::sys.equs.asm' 
0023 56CC
0024 56CC                       include ':QDEquates:qd.data.asm' 
0025 56CC
0026 56CC                       INCLUDE ':QDEquates:core.globals1' 
0027 56CC                       INCLUDE ':QDEquates:core.globals2' 
0028 56CC                       INCLUDE ':QDEquates:region.equs' 
0029 56CC                       INCLUDE ':QDEquates:rect.equs' 
0030 56CC                       INCLUDE ':QDEquates:slab.equs' 
0031 56CC
0032 56CC              ;-----------------------------------------------
0033 56CC              ;
0034 56CC              ;   Imported addresses
0035 56CC              ;
0036 56CC              ;-----------------------------------------------
0037 56CC
0038 56CC                       IMPORT BusyEC12 
0039 56CC                       IMPORT BusyEC4 
0040 56CC                       IMPORT BusyEC8 
0041 56CC                       IMPORT BusyErr0 
0042 56CC                       IMPORT BusyErr12 
0043 56CC                       IMPORT BusyErr4 
0044 56CC                       IMPORT BusyErr8 
0045 56CC                       IMPORT CheckPenVis 
0046 56CC                       IMPORT CommonSlabSetup 
0047 56CC                       IMPORT NextPatSlice 
0048 56CC                       IMPORT QDStart 
0049 56CC                       IMPORT RgnSave 
0050 56CC                       IMPORT SetFirstDestRef 
0051 56CC                       IMPORT SetNextDestRef 
0052 56CC                       IMPORT SpecialNewHandle 
0053 56CC                       IMPORT TestGPs 
0054 56CC
0055 56CC              ;-----------------------------------------------
0056 56CC              ;
0057 56CC              ;   Forward addresses and entries
0058 56CC              ;
0059 56CC              ;-----------------------------------------------
0060 56CC
0061 56CC                       ENTRY CallRgn 
0062 56CC                       ENTRY ClipToRgnA 
0063 56CC                       ENTRY ConTable320 
0064 56CC                       ENTRY ConTable640 
0065 56CC                       ENTRY DeRefA 
0066 56CC                       ENTRY DeRefB 
0067 56CC                       ENTRY DeRefC 
0068 56CC                       ENTRY DerefHandle 
0069 56CC                       ENTRY Expand320 
0070 56CC                       ENTRY Expand640 
0071 56CC                       ENTRY FrRgn 
0072 56CC                       ENTRY GetNextV 
0073 56CC                       ENTRY GetStateInfo 
0074 56CC                       ENTRY InitDataPtr 
0075 56CC                       ENTRY InitRgnUp 
0076 56CC                       ENTRY InvertBuf 
0077 56CC                       ENTRY JoinRgn 
0078 56CC                       ENTRY JoinSetUp 
0079 56CC                       ENTRY LeftBitMask 
0080 56CC                       ENTRY LineSetup 
0081 56CC                       ENTRY RectScanInvert 
0082 56CC                       ENTRY ResizeA 
0083 56CC                       ENTRY ResizeB 
0084 56CC                       ENTRY ResizeHandle 
0085 56CC                       ENTRY RightBitMask 
0086 56CC                       ENTRY SpecialSlab 
0087 56CC                       ENTRY UnlockA 
0088 56CC                       ENTRY UnlockB 
0089 56CC                       ENTRY UnlockC 
0090 56CC                       ENTRY UnlockHandle 
0091 56CC                       ENTRY ValidRgnRect 
0092 56CC                       ENTRY VisToRgnB 
0093 56CC                       ENTRY ZeroRgnA 
0094 56CC                       ENTRY ZeroScanBuf 
0095 56CC                       ENTRY UnlockBufferHandle 
0096 56CC
0097 56CC
0098 56CC              ;                copy regions/draw
0099 56CC              ****************************************************************
0100 56CC              *
0101 56CC              * FrameRgn   (r : rgnHandle)
0102 56CC              *
0103 56CC              *
0104 56CC              ****************************************************************
0105 56CC                       EXPORT FrameRgn 
0106 56CC              FrameRgn PROC 
0107 56CC              *              using PicInfo
0108 56CC
0109 56CC A2 00 00              ldx   #FrameVerb
0110 56CF 80 0D                 bra   JoinRgn
0111 56D1
0112 56D1                       ENDP 
0113 56D1
0114 56D1
0115 56D1              ****************************************************************
0116 56D1              *
0117 56D1              * PaintRgn     (r : rgnHandle)
0118 56D1              *
0119 56D1              *
0120 56D1              ****************************************************************
0121 56D1                       EXPORT PaintRgn 
0122 56D1              PaintRgn PROC 
0123 56D1              *              using PicInfo
0124 56D1
0125 56D1 A2 01 00              ldx   #PaintVerb
0126 56D4 80 08                 bra   JoinRgn
0127 56D6
0128 56D6                       ENDP 
0129 56D6
0130 56D6              ****************************************************************
0131 56D6              *
0132 56D6              * EraseRgn     (r : rgnHandle)
0133 56D6              *
0134 56D6              *
0135 56D6              ****************************************************************
0136 56D6                       EXPORT EraseRgn 
0137 56D6              EraseRgn PROC 
0138 56D6              *              using PicInfo
0139 56D6
0140 56D6 A2 02 00              ldx   #EraseVerb
0141 56D9 80 03                 bra   JoinRgn
0142 56DB
0143 56DB                       ENDP 
0144 56DB
0145 56DB              ****************************************************************
0146 56DB              *
0147 56DB              * InvertRgn    (r : rgnHandle)
0148 56DB              *
0149 56DB              *
0150 56DB              ****************************************************************
0151 56DB                       EXPORT InvertRgn 
0152 56DB              InvertRgn PROC 
0153 56DB              *              using PicInfo
0154 56DB
0155 56DB A2 03 00              ldx   #InvertVerb
0156 56DE              ; let this one fall right into JoinRGN
0157 56DE
0158 56DE                       ENDP 
0159 56DE
0160 56DE              ****************************************************************
0161 56DE              *
0162 56DE              * JoinRgn
0163 56DE              *
0164 56DE              * This is common routine called by Frame, Paint, Invert and
0165 56DE              * erase Rgn.  The draw verb is passed in the x-register
0166 56DE              *
0167 56DE              ****************************************************************
0168 56DE                       EXPORT JoinRgn 
0169 56DE              JoinRgn  PROC 
0170 56DE
0171 56DE              OrigDirect equ   1
0172 56DE              RTL1     equ   OrigDirect+2
0173 56DE              RTL2     equ   RTL1+3
0174 56DE              RHandle  equ   RTL2+3
0175 56DE
0176 56DE 20 AA 0F              jsr   QDStart                  ; x is preserved
0177 56E1
0178 56E1 A3 09                 lda   RHandle,s                ; put rgn handle on zp
0179 56E3 85 70                 sta   RgnHandleC
0180 56E5 A3 0B                 lda   RHandle+2,s
0181 56E7 85 72                 sta   RgnHandleC+2
0182 56E9
0183 56E9 22 0B 57 FE           jsl   CallRgn                  ; call using draw verb in x
0184 56ED AA                    tax                            ; error returned in x
0185 56EE 4C 1C FC              jmp   BusyErr4
0186 56F1
0187 56F1                       ENDP 
0188 56F1
0189 56F1
0190 56F1              ****************************************************************
0191 56F1              *
0192 56F1              * FillRgn      (r : rgnHandle; p : pattern)
0193 56F1              *
0194 56F1              *
0195 56F1              ****************************************************************
0196 56F1                       EXPORT FillRgn 
0197 56F1              FillRgn  PROC 
0198 56F1              *              using PicInfo
0199 56F1              *              using E0Vectors
0200 56F1
0201 56F1              OrigDirect equ   1
0202 56F1              RTL1     equ   OrigDirect+2
0203 56F1              RTL2     equ   RTL1+3
0204 56F1              PPtr     equ   RTL2+3
0205 56F1              RPtr     equ   PPtr+4
0206 56F1
0207 56F1
0208 56F1 20 AA 0F              jsr   QDStart
0209 56F4
0210 56F4 22 40 1E E0           jsl   UserPat2ZP
0211 56F8
0212 56F8 A3 0D                 lda   RPtr,s
0213 56FA 85 70                 sta   RgnHandleC
0214 56FC A3 0F                 lda   RPtr+2,s
0215 56FE 85 72                 sta   RgnHandleC+2
0216 5700
0217 5700
0218 5700 A2 04 00              ldx   #FillVerb
0219 5703 22 0B 57 FE           jsl   CallRgn
0220 5707 AA                    tax   
0221 5708 4C 48 FC              jmp   BusyErr8
0222 570B
0223 570B                       ENDP 
0224 570B
0225 570B
0226 570B
0227 570B              ****************************************************************
0228 570B              *
0229 570B              * CallRgn 
0230 570B              *
0231 570B              * This routine is jumped (or branched) to by the
0232 570B              * entry points after the graf verb is loaded into the
0233 570B              * x register.
0234 570B              *
0235 570B              * Zero page is already switched in by the time it gets here.
0236 570B              *
0237 570B              ****************************************************************
0238 570B                       EXPORT CallRgn 
0239 570B              CallRgn  PROC 
0240 570B              *              using CoreDATA
0241 570B              *              using PicInfo
0242 570B              *              using QDProcs
0243 570B              *              using E0Vectors
0244 570B
0245 570B 86 38                 stx   DrawVerb
0246 570D
0247 570D 20 C3 0F              jsr   TestGPs                  ; if there is a gp pointer
0248 5710 B0 04                 bcs   UseLocal
0249 5712
0250 5712 5C 20 1E E0           jml   StdRgn
0251 5716
0252 5716
0253 5716 8B           UseLocal phb                            ; put extra byte on stack
0254 5717 A0 1C 00              ldy   #o_stdrgn                ; get adr of new rgn routine
0255 571A B7 2A                 lda   [temp],y                 ; put on stack
0256 571C 48                    pha   
0257 571D C8                    iny                            ; get bytes 2 and 3
0258 571E B7 2A                 lda   [temp],y
0259 5720 83 02                 sta   2,s                      ; store middle byte twice
0260 5722 6B                    rtl                            ; call it
0261 5723
0262 5723                       ENDP 
0263 5723
0264 5723
0265 5723              ****************************************************************
0266 5723              *
0267 5723              * StdRgn
0268 5723              *
0269 5723              * Common region routine that is central point for
0270 5723              * all region drawing routines.
0271 5723              *
0272 5723              * When control gets here, all inputs are on zero page.
0273 5723              *       TheRgn is kept at RgnC.
0274 5723              *       ThePat (if any) is in FillPat
0275 5723              *       WhatToDo is in DrawVerb
0276 5723              *
0277 5723              ****************************************************************
0278 5723                       EXPORT iStdRgn 
0279 5723              iStdRgn  PROC 
0280 5723              *              using CoreDATA
0281 5723              *              using PicInfo
0282 5723              *              using QDProcs
0283 5723              *              using E0Vectors
0284 5723
0285 5723                       EXPORT CommonFastRgn 
0286 5723              ;---------------------------------------------------------------
0287 5723 A9 80 00              lda   #RgnNoun
0288 5726 85 3A                 sta   DrawNoun                 ; put on zp too!!!
0289 5728 22 F8 1E E0           jsl   PutPictStuff             ; inputs on zp and in a-reg
0290 572C 90 01                 bcc   NoPicErr
0291 572E 6B                    rtl                            ; return the error
0292 572F
0293 572F A5 38        NoPicErr lda   DrawVerb                 ; put verb in a
0294 5731 D0 0C                 bne   CommonFastRgn
0295 5733
0296 5733 20 45 6B              jsr   RgnSave                  ; does this contribute to region def
0297 5736 90 3F                 bcc   FrRgn                    ; no, so frame it
0298 5738 22 84 1F E0           jsl   PutRgn                   ; yes, so call putrgn 
0299 573C 90 39                 bcc   FrRgn                    ; if no error go on and frame it.
0300 573E 6B                    rtl                            ; return the error
0301 573F              ;---------------------------------------------------------------
0302 573F 20 BF 5A     CommonFastRgn jsr    DeRefC             ;check to see if the region is rectangular
0303 5742 A7 74                 lda    [RgnPtrC]               ;..if it's not, then call CommonSlabSetup
0304 5744 C9 0A 00              cmp    #10
0305 5747 D0 24                 bne    @notRectangle
0306 5749
0307 5749 A0 02 00              ldy    #2                      ;we are rectangular so copy the bounding rect to direct page
0308 574C B7 74                 lda    [RgnPtrC],y
0309 574E 85 A6                 sta    Y1
0310 5750 A0 04 00              ldy    #4
0311 5753 B7 74                 lda    [RgnPtrC],y
0312 5755 85 A8                 sta    X1
0313 5757 A0 06 00              ldy    #6
0314 575A B7 74                 lda    [RgnPtrC],y
0315 575C 85 AA                 sta    Y2
0316 575E A0 08 00              ldy    #8
0317 5761 B7 74                 lda    [RgnPtrC],y
0318 5763 85 AC                 sta    X2
0319 5765 20 D5 5A              jsr    UnlockC                 ;unlock the region handle
0320 5768
0321 5768 A9 30 00              lda   #RectNoun
0322 576B 85 3A                 sta   DrawNoun
0323 576D              @notRectangle  
0324 576D 4C A4 2E              jmp   CommonSlabSetup
0325 5770              ;---------------------------------------------------------------
0326 5770
0327 5770                       ENDP 
0328 5770
0329 5770
0330 5770
0331 5770              ****************************************************************
0332 5770              *
0333 5770              * PRgn, FRgn, IRgn, ERgn
0334 5770              *
0335 5770              ****************************************************************
0336 5770                       EXPORT PRgn 
0337 5770              PRgn     PROC 
0338 5770                       ENDP 
0339 5770                       EXPORT FRgn 
0340 5770              FRgn     PROC 
0341 5770                       ENDP 
0342 5770                       EXPORT IRgn 
0343 5770              IRgn     PROC 
0344 5770                       ENDP 
0345 5770                       EXPORT ERgn 
0346 5770              ERgn     PROC 
0347 5770              *              using PicInfo
0348 5770
0349 5770 A9 80 00              lda   #RgnNoun
0350 5773 85 3A                 sta   DrawNoun
0351 5775 80 C8                 bra    CommonFastRgn
0352 5777
0353 5777
0354 5777                       ENDP 
0355 5777
0356 5777
0357 5777
0358 5777
0359 5777
0360 5777              ****************************************************************
0361 5777              *
0362 5777              * FrRgn
0363 5777              *
0364 5777              * Modifications:
0365 5777              *
0366 5777              *    April 13, 1986    First I was not unlocking the region to
0367 5777              *                      frame when it was not a rectangle.
0368 5777              *
0369 5777              *                      Finally I was disposing of the temp region
0370 5777              *                      wrong (pushed the handle on the stack
0371 5777              *                      backwards).
0372 5777              *
0373 5777              ****************************************************************
0374 5777                       EXPORT FrRgn 
0375 5777              FrRgn    PROC 
0376 5777              *              using CoreDATA
0377 5777              *              using E0Vectors
0378 5777
0379 5777 20 17 34              jsr   CheckPenVis              ; don't come back unless visible
0380 577A
0381 577A 20 BF 5A              jsr   DeRefC                   ; look at the region and see if it
0382 577D A7 74                 lda   [RgnPtrC]                ; is rectangular?
0383 577F C9 0A 00              cmp   #10
0384 5782 D0 20                 bne   NotRect
0385 5784
0386 5784 A0 02 00              ldy   #2                       ; yes it is so copy the bounds rect
0387 5787 B7 74                 lda   [RgnPtrC],y              ; from the region to rect on zero page
0388 5789 85 A6                 sta   Y1
0389 578B C8                    iny   
0390 578C C8                    iny   
0391 578D B7 74                 lda   [RgnPtrC],y
0392 578F 85 A8                 sta   X1
0393 5791 C8                    iny   
0394 5792 C8                    iny   
0395 5793 B7 74                 lda   [RgnPtrC],y
0396 5795 85 AA                 sta   Y2
0397 5797 C8                    iny   
0398 5798 C8                    iny   
0399 5799 B7 74                 lda   [RgnPtrC],y
0400 579B 85 AC                 sta   X2
0401 579D 20 D5 5A              jsr   UnlockC                  ; now free the region
0402 57A0
0403 57A0 5C 2C 1F E0           jml   v_FrRect                 ; jump to internal frame rect routine
0404 57A4              *			; through vector in bank E0.
0405 57A4
0406 57A4
0407 57A4
0408 57A4
0409 57A4              NotRect                                 ; 
0410 57A4
0411 57A4 20 D5 5A              jsr   UnlockC                  ; don't need it locked any more
0412 57A7
0413 57A7 A0 44 00              ldy   #o_pnSize                ; get the pen size on the stack
0414 57AA B7 24                 lda   [PortRef],y
0415 57AC 48                    pha   
0416 57AD C8                    iny   
0417 57AE C8                    iny   
0418 57AF B7 24                 lda   [PortRef],y
0419 57B1 48                    pha   
0420 57B2
0421 57B2 D4 72                 pei   RgnHandleC+2             ; put rgnhandle c on stack
0422 57B4 D4 70                 pei   RgnHandleC
0423 57B6
0424 57B6 F4 00 00 F4           PushLong #0                    ; put handle to new region on stack
0425 57BC A2 04 67 22           _NewRgn 
0426 57C3
0427 57C3 0B                    phd   
0428 57C4 3B                    tsc                            ; make stack into zero page
0429 57C5 5B                    tcd   
0430 57C6
0431 57C6              OrigDirect equ   1
0432 57C6              TempRgn  equ   3                        ; now these are the zero page
0433 57C6              UserRgn  equ   7                        ; vars I'll deal with.
0434 57C6              PenX     equ   11
0435 57C6              PenY     equ   13
0436 57C6
0437 57C6 D4 09                 pei   UserRgn+2                ; first TempRgn := UserRgn
0438 57C8 D4 07                 pei   UserRgn
0439 57CA D4 05                 pei   TempRgn+2
0440 57CC D4 03                 pei   TempRgn
0441 57CE A2 04 69 22           _CopyRgn 
0442 57D5
0443 57D5 D4 05                 pei   TempRgn+2                ; TempRgn :=InsetRgn(TempRgn,Penx,PenY)
0444 57D7 D4 03                 pei   TempRgn
0445 57D9 D4 0B                 pei   PenX
0446 57DB D4 0D                 pei   PenY
0447 57DD A2 04 70 22           _InsetRgn 
0448 57E4
0449 57E4 D4 09                 pei   UserRgn+2                ; TempRgn := UserRgn - TempRgn
0450 57E6 D4 07                 pei   UserRgn
0451 57E8 D4 05                 pei   TempRgn+2
0452 57EA D4 03                 pei   TempRgn
0453 57EC D4 05                 pei   TempRgn+2
0454 57EE D4 03                 pei   TempRgn
0455 57F0 A2 04 73 22           _DiffRgn 
0456 57F7
0457 57F7 A5 03                 lda   TempRgn
0458 57F9 A6 05                 ldx   TempRgn+2
0459 57FB
0460 57FB 2B                    pld                            ; restore zp
0461 57FC
0462 57FC 7A                    ply                            ; clear off stack without
0463 57FD 7A                    ply                            ; hurting a reg
0464 57FE 7A                    ply   
0465 57FF 7A                    ply   
0466 5800 7A                    ply   
0467 5801 7A                    ply   
0468 5802
0469 5802 85 70                 sta   RgnHandleC               ; put the handle to temp rgn in
0470 5804 86 72                 stx   RgnHandleC+2             ; RgnHandleC
0471 5806
0472 5806 22 70 57 FE           jsl   PRgn                     ; call PRgn
0473 580A
0474 580A D4 72                 pei   RgnHandleC+2             ; Noe dispose it
0475 580C D4 70                 pei   RgnHandleC
0476 580E A2 04 68 22           _DisposeRgn 
0477 5815
0478 5815 A9 00 00              lda   #0
0479 5818 18                    clc   
0480 5819 6B                    rtl   
0481 581A
0482 581A                       ENDP 
0483 581A
0484 581A
0485 581A              ****************************************************************
0486 581A              *
0487 581A              * DrawRgn
0488 581A              *
0489 581A              * Draws the specified region using the pattern kept in
0490 581A              * FillPat, using the mode kept in FillMode
0491 581A              *
0492 581A              ****************************************************************
0493 581A                       EXPORT DrawRgn 
0494 581A              DrawRgn  PROC 
0495 581A              *              using E0Vectors
0496 581A
0497 581A 8B                    phb                            ; save the bank reg here
0498 581B
0499 581B 22 C4 1E E0           jsl   Init3Regions
0500 581F 22 E8 1E E0           jsl   SetSlabAdr               ; sets up the slab adr on zp
0501 5823 22 70 1E E0           jsl   XSetup
0502 5827
0503 5827 20 47 34              jsr   SetFirstDestRef
0504 582A
0505 582A              RgnLoop                                 ; 
0506 582A
0507 582A 20 C5 34              jsr   NextPatSlice
0508 582D
0509 582D 22 D0 1E E0           jsl   Seek3Regions
0510 5831
0511 5831 22 00 1E E0           jsl   ToSlab
0512 5835
0513 5835 A5 40                 lda   CurrentY
0514 5837 1A                    inc   a
0515 5838 C5 AA                 cmp   Y2
0516 583A 10 07                 bpl   TheEnd                   ; hey moron, signed compare 28 Mar 86
0517 583C
0518 583C 85 40                 sta   CurrentY
0519 583E 20 F4 34              jsr   SetNextDestRef
0520 5841 80 E7                 bra   RgnLoop
0521 5843
0522 5843 AB           TheEnd   plb                            ; restore bank
0523 5844 6B                    rtl   
0524 5845
0525 5845                       ENDP 
0526 5845
0527 5845
0528 5845
0529 5845              ****************************************************************
0530 5845              *
0531 5845              * GetBoundsC
0532 5845              *
0533 5845              * Gets the bounds rect of rgn c and puts it in MinRect
0534 5845              *
0535 5845              ****************************************************************
0536 5845                       EXPORT GetBoundsC 
0537 5845              GetBoundsC PROC 
0538 5845
0539 5845 A0 02 00              ldy   #2
0540 5848 A2 00 00              ldx   #0
0541 584B
0542 584B B7 74        Loop     lda   [RgnPtrC],y
0543 584D 95 00                 sta   MinRect,x
0544 584F C8                    iny   
0545 5850 C8                    iny   
0546 5851 E8                    inx   
0547 5852 E8                    inx   
0548 5853 C0 0A 00              cpy   #10
0549 5856 90 F3                 bcc   Loop
0550 5858
0551 5858 60                    rts   
0552 5859
0553 5859                       ENDP 
0554 5859
0555 5859
0556 5859              ****************************************************************
0557 5859              *
0558 5859              * NewRgn
0559 5859              *
0560 5859              ****************************************************************
0561 5859                       EXPORT NewRgn 
0562 5859              NewRgn   PROC 
0563 5859              *              using RegionData
0564 5859
0565 5859              OrigDirect equ   1
0566 5859              RTL1     equ   OrigDirect+2
0567 5859              RTL2     equ   RTL1+3
0568 5859              ResultHandle equ   RTL2+3
0569 5859
0570 5859
0571 5859 20 AA 0F              jsr   QDStart
0572 585C
0573 585C A9 0A 00              lda   #10                      ; size
0574 585F A6 0A                 ldx   UserID
0575 5861 A0 00 00              ldy   #RgnAttributes
0576 5864 20 3B 13              jsr   SpecialNewHandle
0577 5867 B0 1B                 bcs   Error
0578 5869
0579 5869 86 50                 stx   RgnHandleA
0580 586B 84 52                 sty   RgnHandleA+2
0581 586D 8A                    txa   
0582 586E 83 09                 sta   ResultHandle,s
0583 5870 98                    tya   
0584 5871 83 0B                 sta   ResultHandle+2,s
0585 5873
0586 5873 20 7D 5A              jsr   DeRefA
0587 5876
0588 5876 A9 0A 00              lda   #10                      ; set region to null region
0589 5879 87 54                 sta   [RgnPtrA]                ; size is 10
0590 587B
0591 587B 20 C4 58              jsr   ZeroRgnA
0592 587E
0593 587E 20 93 5A              jsr   UnlockA
0594 5881
0595 5881 A9 00 00              lda   #0
0596 5884
0597 5884 AA           Error    tax                            ; put error in x
0598 5885 4C ED FB              jmp   BusyErr0                 ; quit
0599 5888
0600 5888
0601 5888                       ENDP 
0602 5888
0603 5888
0604 5888              ****************************************************************
0605 5888              *
0606 5888              * DisposeRgn
0607 5888              *
0608 5888              *
0609 5888              *
0610 5888              ****************************************************************
0611 5888                       EXPORT DisposeRgn 
0612 5888              DisposeRgn PROC 
0613 5888              *              using RegionData
0614 5888
0615 5888              OrigDirect equ   1
0616 5888              RTL1     equ   OrigDirect+2
0617 5888              RTL2     equ   RTL1+3
0618 5888              TheHandle equ   RTL2+3
0619 5888
0620 5888
0621 5888 20 AA 0F              jsr   QDStart
0622 588B
0623 588B A3 09                 lda   TheHandle,s
0624 588D AA                    tax   
0625 588E A3 0B                 lda   TheHandle+2,s
0626 5890 48                    pha   
0627 5891 DA                    phx   
0628 5892 A2 02 10 22           _DisposeHandle 
0629 5899
0630 5899 AA                    tax                            ; propagate any error that may
0631 589A 4C 1C FC              jmp   BusyErr4                 ; occur
0632 589D
0633 589D
0634 589D                       ENDP 
0635 589D
0636 589D
0637 589D
0638 589D
0639 589D              ****************************************************************
0640 589D              *
0641 589D              * SetEmptyRgn
0642 589D              *
0643 589D              * Sets the region to the empty region.  The must already be
0644 589D              * allocated
0645 589D              *
0646 589D              ****************************************************************
0647 589D                       EXPORT SetEmptyRgn 
0648 589D              SetEmptyRgn PROC 
0649 589D              OrigDirect equ   1
0650 589D              RTL1     equ   OrigDirect+2
0651 589D              RTL2     equ   RTL1+3
0652 589D              RgnHandle equ   RTL2+3
0653 589D
0654 589D 20 AA 0F              jsr   QDStart
0655 58A0
0656 58A0 A3 09                 lda   RgnHandle,s
0657 58A2 85 50                 sta   RgnHandleA
0658 58A4 A3 0B                 lda   RgnHandle+2,s
0659 58A6 85 52                 sta   RgnHandleA+2
0660 58A8 20 7D 5A              jsr   DeRefA
0661 58AB
0662 58AB
0663 58AB A9 0A 00              lda   #10
0664 58AE C7 54                 cmp   [RgnPtrA]
0665 58B0 F0 05                 beq   SizeOK
0666 58B2
0667 58B2 20 E0 5A              jsr   ResizeA
0668 58B5 B0 09                 bcs   error
0669 58B7
0670 58B7 20 C4 58     SizeOK   jsr   ZeroRgnA
0671 58BA
0672 58BA 20 93 5A              jsr   UnlockA
0673 58BD
0674 58BD 4C 19 FC              jmp   BusyEC4
0675 58C0
0676 58C0 AA           error    tax   
0677 58C1 4C 1C FC              jmp   BusyErr4
0678 58C4
0679 58C4                       ENDP 
0680 58C4
0681 58C4
0682 58C4
0683 58C4              ****************************************************************
0684 58C4              *
0685 58C4              * ZeroRgnA
0686 58C4              *
0687 58C4              * An internal routine to zero the bounding box of the region
0688 58C4              * pointed to by RgnPtrA.
0689 58C4              *
0690 58C4              * A & Y are lost, X is unchanged.
0691 58C4              *
0692 58C4              ****************************************************************
0693 58C4                       EXPORT ZeroRgnA 
0694 58C4              ZeroRgnA PROC 
0695 58C4
0696 58C4 A0 02 00              ldy   #2
0697 58C7 A9 00 00              lda   #0
0698 58CA 97 54        Loop     sta   [RgnPtrA],y
0699 58CC C8                    iny   
0700 58CD C8                    iny   
0701 58CE C0 0A 00              cpy   #10
0702 58D1 90 F7                 bcc   Loop
0703 58D3
0704 58D3 60                    rts   
0705 58D4
0706 58D4                       ENDP 
0707 58D4
0708 58D4
0709 58D4
0710 58D4
0711 58D4              ****************************************************************
0712 58D4              *
0713 58D4              * SetRectRgn
0714 58D4              *              RgnHandle : handle
0715 58D4              *              Left, Top, Right, Bottom : integer
0716 58D4              *
0717 58D4              * This takes the region pointed described by RgnHandle and
0718 58D4              * sets it to a rectangular region described by four integers
0719 58D4              *
0720 58D4              * If the rectangle is not valid, then the region is set to
0721 58D4              * the zero rect ([0,0,0,0]).
0722 58D4              *
0723 58D4              ****************************************************************
0724 58D4                       EXPORT SetRectRgn 
0725 58D4              SetRectRgn PROC 
0726 58D4              *              using RegionData
0727 58D4
0728 58D4              OrigDirect equ   1
0729 58D4              RTL1     equ   OrigDirect+2
0730 58D4              RTL2     equ   RTL1+3
0731 58D4              Bottom   equ   RTL2+3
0732 58D4              Right    equ   Bottom+2
0733 58D4              Top      equ   Right+2
0734 58D4              Left     equ   Top+2
0735 58D4              RgnHandle equ   Left+2
0736 58D4
0737 58D4 20 AA 0F              jsr   QDStart
0738 58D7
0739 58D7 A3 11                 lda   RgnHandle,s              ; get the handle and deref it
0740 58D9 85 50                 sta   RgnHandleA
0741 58DB A3 13                 lda   RgnHandle+2,s
0742 58DD 85 52                 sta   RgnHandleA+2
0743 58DF 20 7D 5A              jsr   DeRefA
0744 58E2
0745 58E2 A9 0A 00              lda   #10
0746 58E5 C7 54                 cmp   [RgnPtrA]
0747 58E7 F0 05                 beq   SizeOK
0748 58E9
0749 58E9 20 E0 5A              jsr   ResizeA
0750 58EC B0 22                 bcs   error
0751 58EE
0752 58EE A0 02 00     SizeOk   ldy   #2
0753 58F1 A3 0D                 lda   Top,s
0754 58F3 97 54                 sta   [RgnPtrA],y
0755 58F5 C8                    iny   
0756 58F6 C8                    iny   
0757 58F7 A3 0F                 lda   Left,s
0758 58F9 97 54                 sta   [RgnPtrA],y
0759 58FB C8                    iny   
0760 58FC C8                    iny   
0761 58FD A3 09                 lda   Bottom,s
0762 58FF 97 54                 sta   [RgnPtrA],y
0763 5901 C8                    iny   
0764 5902 C8                    iny   
0765 5903 A3 0B                 lda   Right,s
0766 5905 97 54                 sta   [RgnPtrA],y
0767 5907
0768 5907
0769 5907 20 14 59              jsr   ValidRgnRect
0770 590A
0771 590A 20 93 5A     AllDone  jsr   UnlockA
0772 590D 4C 71 FC              jmp   BusyEC12
0773 5910
0774 5910 AA           error    tax   
0775 5911 4C 74 FC              jmp   BusyErr12
0776 5914
0777 5914
0778 5914
0779 5914                       ENDP 
0780 5914
0781 5914
0782 5914
0783 5914              ****************************************************************
0784 5914              *
0785 5914              * ValidRgnRect
0786 5914              *
0787 5914              * This is an internal routine to make sure that the contents
0788 5914              * of region A's bounding box is valid.  If the contents are
0789 5914              * not valid, they are reset to zero.
0790 5914              *
0791 5914              ****************************************************************
0792 5914                       EXPORT ValidRgnRect 
0793 5914              ValidRgnRect PROC 
0794 5914
0795 5914 A0 02 00              ldy   #2
0796 5917 B7 54                 lda   [RgnPtrA],y
0797 5919 A0 06 00              ldy   #6
0798 591C D7 54                 cmp   [RgnPtrA],y
0799 591E 10 0D                 bpl   ZeroRect
0800 5920
0801 5920 A0 04 00              ldy   #4
0802 5923 B7 54                 lda   [RgnPtrA],y
0803 5925 A0 08 00              ldy   #8
0804 5928 D7 54                 cmp   [RgnPtrA],y
0805 592A 10 01                 bpl   ZeroRect
0806 592C
0807 592C 60           AllDone  rts   
0808 592D
0809 592D 20 C4 58     ZeroRect jsr   ZeroRgnA
0810 5930 80 FA                 bra   AllDone
0811 5932
0812 5932                       ENDP 
0813 5932
0814 5932              ****************************************************************
0815 5932              *
0816 5932              * RectRgn
0817 5932              *              RgnHandle : handle
0818 5932              *              RectPtr   : ptr
0819 5932              *
0820 5932              * This takes the region pointed described by RgnHandle and
0821 5932              * sets it to a rectangular region described by the rectangle.
0822 5932              *
0823 5932              * If the rectangle is not valid, then the region is set to
0824 5932              * the zero rect ([0,0,0,0]).
0825 5932              *
0826 5932              ****************************************************************
0827 5932                       EXPORT RectRgn 
0828 5932              RectRgn  PROC 
0829 5932              *              using RegionData
0830 5932
0831 5932              OrigDirect equ   1
0832 5932              RTL1     equ   OrigDirect+2
0833 5932              RTL2     equ   RTL1+3
0834 5932              RectPtr  equ   RTL2+3
0835 5932              RgnHandle equ   RectPtr+4
0836 5932
0837 5932 20 AA 0F              jsr   QDStart
0838 5935
0839 5935 A3 0D                 lda   RgnHandle,s
0840 5937 85 50                 sta   RgnHandleA
0841 5939 A3 0F                 lda   RgnHandle+2,s
0842 593B 85 52                 sta   RgnHandleA+2
0843 593D 20 7D 5A              jsr   DeRefA
0844 5940
0845 5940
0846 5940 A9 0A 00              lda   #10
0847 5943 C7 54                 cmp   [RgnPtrA]
0848 5945 F0 05                 beq   SizeOK
0849 5947
0850 5947 20 E0 5A              jsr   ResizeA
0851 594A B0 1F                 bcs   error
0852 594C
0853 594C A3 09        SizeOk   lda   RectPtr,s
0854 594E 85 2A                 sta   Temp
0855 5950 A3 0B                 lda   RectPtr+2,s
0856 5952 85 2C                 sta   Temp+2
0857 5954
0858 5954
0859 5954 A0 00 00              ldy   #0                       ; copy the rect to the
0860 5957 B7 2A        Loop     lda   [Temp],y                 ; region's bounding box
0861 5959 C8                    iny   
0862 595A C8                    iny   
0863 595B 97 54                 sta   [RgnPtrA],y
0864 595D C0 08 00              cpy   #8
0865 5960 90 F5                 bcc   Loop
0866 5962
0867 5962 20 14 59              jsr   ValidRgnRect             ; now make sure its valid
0868 5965
0869 5965
0870 5965 20 93 5A     AllDone  jsr   UnlockA
0871 5968 4C 45 FC              jmp   BusyEC8
0872 596B
0873 596B AA           error    tax   
0874 596C 4C 48 FC              jmp   BusyErr8
0875 596F
0876 596F
0877 596F                       ENDP 
0878 596F
0879 596F
0880 596F
0881 596F
0882 596F
0883 596F              ****************************************************************
0884 596F              *
0885 596F              * CopyRgn
0886 596F              *              SrcRgn : Handle
0887 596F              *              DestRgn : Handle
0888 596F              *
0889 596F              * ChangeHistory
0890 596F              *
0891 596F              * 26 Oct 88         Steven Glass
0892 596F              *
0893 596F              * Two changes.  First I use the memmover routine in ROM
0894 596F              * instead of _blockmove.  Second, I look for the simple
0895 596F              * case where there are only ten bytes to move and do
0896 596F              * them in line.
0897 596F              *
0898 596F              ****************************************************************
0899 596F              CopyRgn  PROC EXPORT 
0900 596F              OrigDirect equ   1
0901 596F              RTL1     equ   OrigDirect+2
0902 596F              RTL2     equ   RTL1+3
0903 596F              DestHandle equ   RTL2+3
0904 596F              SrcHandle equ   DestHandle+4
0905 596F
0906 596F 20 AA 0F              jsr   QDStart
0907 5972
0908 5972 A3 0D                 lda   SrcHandle,s              ; dereference the src
0909 5974 85 50                 sta   RgnHandleA
0910 5976 A3 0F                 lda   SrcHandle+2,s
0911 5978 85 52                 sta   RgnHandleA+2
0912 597A 20 7D 5A              jsr   DeRefA
0913 597D
0914 597D A3 09                 lda   DestHandle,s             ; dereference the dest
0915 597F 85 60                 sta   RgnHandleB
0916 5981 A3 0B                 lda   DestHandle+2,s
0917 5983 85 62                 sta   RgnHandleB+2
0918 5985 20 9E 5A              jsr   DeRefB
0919 5988
0920 5988 A7 54                 lda   [RgnPtrA]                ; get source size
0921 598A C7 64                 cmp   [RgnPtrB]                ; compare to dest size
0922 598C F0 05                 beq   SizeOK
0923 598E
0924 598E
0925 598E 20 EF 5A              jsr   ResizeB
0926 5991 B0 45                 bcs   error
0927 5993
0928 5993
0929 5993              SizeOk    
0930 5993
0931 5993 A7 54                 lda   [RgnPtrA]                ; is this a simple rect region?
0932 5995 C9 0A 00              cmp   #10
0933 5998 D0 20                 bne   NotSimple
0934 599A
0935 599A 87 64                 sta   [RgnPtrB]                ; move it inline.
0936 599C A0 02 00              ldy   #2
0937 599F B7 54                 lda   [RgnPtrA],y
0938 59A1 97 64                 sta   [RgnPtrB],y
0939 59A3 A0 04 00              ldy   #4
0940 59A6 B7 54                 lda   [RgnPtrA],y
0941 59A8 97 64                 sta   [RgnPtrB],y
0942 59AA A0 06 00              ldy   #6
0943 59AD B7 54                 lda   [RgnPtrA],y
0944 59AF 97 64                 sta   [RgnPtrB],y
0945 59B1 A0 08 00              ldy   #8
0946 59B4 B7 54                 lda   [RgnPtrA],y
0947 59B6 97 64                 sta   [RgnPtrB],y
0948 59B8 80 15                 bra   AllDone
0949 59BA
0950 59BA              NotSimple                               ; move it the hard way.
0951 59BA
0952 59BA D4 56                 pei   RgnPtrA+2                ; Src ptr
0953 59BC D4 54                 pei   RgnPtrA
0954 59BE D4 66                 pei   RgnPtrB+2                ; dest ptr
0955 59C0 D4 64                 pei   RgnPtrB
0956 59C2 F4 00 00              PushWord #0 
0957 59C5 A7 54                 lda   [RgnPtrA]
0958 59C7 48                    pha                            ; how many to move
0959 59C8 F4 05 08              PushWord #BlockMoveCommandWord 
0960 59CB 22 00 02 E1           jsl   ToMemMover
0961 59CF
0962 59CF              AllDone   
0963 59CF 20 93 5A              jsr   UnlockA
0964 59D2 20 B4 5A              jsr   UnlockB
0965 59D5
0966 59D5 4C 45 FC              jmp   BusyEC8
0967 59D8
0968 59D8 AA           error    tax   
0969 59D9 4C 48 FC              jmp   BusyErr8
0970 59DC
0971 59DC
0972 59DC                       ENDP 
0973 59DC
0974 59DC
0975 59DC              ****************************************************************
0976 59DC              *
0977 59DC              * EqualRgn
0978 59DC              *
0979 59DC              *          Rgn1  : handle
0980 59DC              *          Rgn2  : handle
0981 59DC              *
0982 59DC              * Returns true if the two regions are identical.
0983 59DC              *
0984 59DC              ****************************************************************
0985 59DC                       EXPORT EqualRgn 
0986 59DC              EqualRgn PROC 
0987 59DC              OrigDirect equ   1
0988 59DC              RTL1     equ   OrigDirect+2
0989 59DC              RTL2     equ   RTL1+3
0990 59DC              Rgn1     equ   RTL2+3
0991 59DC              Rgn2     equ   Rgn1+4
0992 59DC              Result   equ   Rgn2+4
0993 59DC
0994 59DC 20 AA 0F              jsr   QDStart
0995 59DF
0996 59DF A3 09                 lda   Rgn1,s                   ; dereference one
0997 59E1 85 50                 sta   RgnHandleA
0998 59E3 A3 0B                 lda   Rgn1+2,s
0999 59E5 85 52                 sta   RgnHandleA+2
1000 59E7 20 7D 5A              jsr   DeRefA
1001 59EA
1002 59EA A3 0D                 lda   Rgn2,s                   ; dereference the other
1003 59EC 85 60                 sta   RgnHandleB
1004 59EE A3 0F                 lda   Rgn2+2,s
1005 59F0 85 62                 sta   RgnHandleB+2
1006 59F2 20 9E 5A              jsr   DeRefB
1007 59F5
1008 59F5 A7 54                 lda   [RgnPtrA]                ; get size of one
1009 59F7 C7 64                 cmp   [RgnPtrB]                ; compare to size of other
1010 59F9 D0 1B                 bne   NotEqual
1011 59FB
1012 59FB
1013 59FB A8                    tay   
1014 59FC 88                    dey   
1015 59FD 88                    dey   
1016 59FE B7 54        Loop     lda   [RgnPtrA],y
1017 5A00 D7 64                 cmp   [RgnPtrB],y
1018 5A02 D0 12                 bne   NotEqual
1019 5A04 88                    dey   
1020 5A05 88                    dey   
1021 5A06 D0 F6                 bne   Loop
1022 5A08
1023 5A08 A9 FF FF              lda   #True
1024 5A0B
1025 5A0B 83 11        AllDone  sta   Result,s
1026 5A0D 20 93 5A              jsr   UnlockA
1027 5A10 20 B4 5A              jsr   UnlockB
1028 5A13 4C 45 FC              jmp   BusyEC8
1029 5A16
1030 5A16 A9 00 00     NotEqual lda   #False
1031 5A19 80 F0                 bra   AllDone
1032 5A1B
1033 5A1B                       ENDP 
1034 5A1B
1035 5A1B
1036 5A1B              ****************************************************************
1037 5A1B              *
1038 5A1B              * EmptyRgn
1039 5A1B              *
1040 5A1B              *          Rgn  : handle
1041 5A1B              *
1042 5A1B              * Returns true if the region is rectangular and its bounding
1043 5A1B              * box is set an invalid rectangle (top greater than or equal to
1044 5A1B              * bottom or left greater than or equal to right)
1045 5A1B              *
1046 5A1B              * Modified 4 apr 86	SEG
1047 5A1B              *
1048 5A1B              *    This used to return true only if bounding box was set to
1049 5A1B              *    all zeros.  This was not good enough since regions can
1050 5A1B              *    be empty and not set this way.
1051 5A1B              *
1052 5A1B              ****************************************************************
1053 5A1B                       EXPORT EmptyRgn 
1054 5A1B              EmptyRgn PROC 
1055 5A1B              OrigDirect equ   1
1056 5A1B              RTL1     equ   OrigDirect+2
1057 5A1B              RTL2     equ   RTL1+3
1058 5A1B              Rgn      equ   RTL2+3
1059 5A1B              Result   equ   Rgn+4
1060 5A1B
1061 5A1B 20 AA 0F              jsr   QDStart
1062 5A1E
1063 5A1E A3 09                 lda   Rgn,s                    ; dereference the rgn
1064 5A20 85 50                 sta   RgnHandleA
1065 5A22 A3 0B                 lda   Rgn+2,s
1066 5A24 85 52                 sta   RgnHandleA+2
1067 5A26 20 7D 5A              jsr   DeRefA
1068 5A29
1069 5A29 A7 54                 lda   [RgnPtrA]                ; get source size
1070 5A2B C9 0A 00              cmp   #10
1071 5A2E D0 23                 bne   NotEmpty
1072 5A30
1073 5A30
1074 5A30 A0 02 00              ldy   #2
1075 5A33 B7 54                 lda   [RgnPtrA],y
1076 5A35 A0 06 00              ldy   #6
1077 5A38 D7 54                 cmp   [RgnPtrA],y
1078 5A3A 10 0C                 bpl   YesZero
1079 5A3C
1080 5A3C A0 04 00              ldy   #4
1081 5A3F B7 54                 lda   [RgnPtrA],y
1082 5A41 A0 08 00              ldy   #8
1083 5A44 D7 54                 cmp   [RgnPtrA],y
1084 5A46 30 0B                 bmi   NotEmpty
1085 5A48
1086 5A48 A9 FF FF     YesZero  lda   #True
1087 5A4B
1088 5A4B 83 0D        AllDone  sta   Result,s
1089 5A4D 20 93 5A              jsr   UnlockA
1090 5A50 4C 19 FC              jmp   BusyEC4
1091 5A53
1092 5A53 A9 00 00     NotEmpty lda   #False
1093 5A56 80 F3                 bra   AllDone
1094 5A58
1095 5A58                       ENDP 
1096 5A58
1097 5A58
1098 5A58
1099 5A58
1100 5A58
1101 5A58              ****************************************************************
1102 5A58              *
1103 5A58              * DeRefAndLock
1104 5A58              *
1105 5A58              * This takes a handle in the A & X registers and dereferences
1106 5A58              * and locks it.
1107 5A58              *
1108 5A58              * The result ptr is returned in a & x.
1109 5A58              *
1110 5A58              * The location TEMP on zero page is trashed as is Y
1111 5A58              ****************************************************************
1112 5A58                       EXPORT DeRefAndLock 
1113 5A58              DeRefAndLock PROC 
1114 5A58                       EXPORT DeRefAndLoc 
1115 5A58              DeRefAndLoc                             ;       
1116 5A58
1117 5A58 85 2A                 sta   Temp
1118 5A5A 86 2C                 stx   Temp+2
1119 5A5C
1120 5A5C A0 04 00              ldy   #4
1121 5A5F B7 2A                 lda   [Temp],y
1122 5A61 09 00 80              ora   #$8000
1123 5A64 97 2A                 sta   [Temp],y
1124 5A66
1125 5A66 88                    dey   
1126 5A67 88                    dey   
1127 5A68 B7 2A                 lda   [Temp],y
1128 5A6A AA                    tax   
1129 5A6B A7 2A                 lda   [Temp]
1130 5A6D
1131 5A6D 60                    rts   
1132 5A6E
1133 5A6E                       ENDP 
1134 5A6E
1135 5A6E
1136 5A6E              ****************************************************************
1137 5A6E              *
1138 5A6E              * Unlock Mem
1139 5A6E              *
1140 5A6E              * This is used after a handle has been locked to release it.
1141 5A6E              *
1142 5A6E              * Like DeRefAndLock, the handle is passed in the A & X registers.
1143 5A6E              *
1144 5A6E              ****************************************************************
1145 5A6E                       EXPORT UnlockMem 
1146 5A6E              UnlockMem PROC 
1147 5A6E
1148 5A6E 85 2A                 sta   Temp
1149 5A70 86 2C                 stx   Temp+2
1150 5A72
1151 5A72 A0 04 00              ldy   #4
1152 5A75 B7 2A                 lda   [Temp],y
1153 5A77 29 FF 7F              and   #$7FFF
1154 5A7A 97 2A                 sta   [Temp],y
1155 5A7C
1156 5A7C 60                    rts   
1157 5A7D                       ENDP 
1158 5A7D
1159 5A7D
1160 5A7D
1161 5A7D              ****************************************************************
1162 5A7D              *
1163 5A7D              * DeRefA
1164 5A7D              *
1165 5A7D              ****************************************************************
1166 5A7D                       EXPORT DeRefA 
1167 5A7D              DeRefA   PROC 
1168 5A7D
1169 5A7D A0 04 00              ldy   #4                       ; lock it
1170 5A80 B7 50                 lda   [RgnHandleA],y
1171 5A82 09 00 80              ora   #$8000
1172 5A85 97 50                 sta   [RgnHandleA],y
1173 5A87
1174 5A87 A7 50                 lda   [RgnHandleA]             ; deref it.
1175 5A89 85 54                 sta   RgnPtrA
1176 5A8B A0 02 00              ldy   #2
1177 5A8E B7 50                 lda   [RgnHandleA],y
1178 5A90 85 56                 sta   RgnPtrA+2
1179 5A92 60                    rts   
1180 5A93
1181 5A93
1182 5A93
1183 5A93                       ENDP 
1184 5A93
1185 5A93              ****************************************************************
1186 5A93              *
1187 5A93              * UnlockA
1188 5A93              *
1189 5A93              ****************************************************************
1190 5A93                       EXPORT UnlockA 
1191 5A93              UnlockA  PROC 
1192 5A93
1193 5A93 A0 04 00              ldy   #4                       ; unlock it
1194 5A96 B7 50                 lda   [RgnHandleA],y
1195 5A98 29 FF 7F              and   #$7FFF
1196 5A9B 97 50                 sta   [RgnHandleA],y
1197 5A9D 60                    rts   
1198 5A9E
1199 5A9E                       ENDP 
1200 5A9E
1201 5A9E              ****************************************************************
1202 5A9E              *
1203 5A9E              * DeRefB
1204 5A9E              *
1205 5A9E              ****************************************************************
1206 5A9E                       EXPORT DeRefB 
1207 5A9E              DeRefB   PROC 
1208 5A9E
1209 5A9E A0 04 00              ldy   #4                       ; lock it
1210 5AA1 B7 60                 lda   [RgnHandleB],y
1211 5AA3 09 00 80              ora   #$8000
1212 5AA6 97 60                 sta   [RgnHandleB],y
1213 5AA8
1214 5AA8 A7 60                 lda   [RgnHandleB]             ; deref it.
1215 5AAA 85 64                 sta   RgnPtrB
1216 5AAC A0 02 00              ldy   #2
1217 5AAF B7 60                 lda   [RgnHandleB],y
1218 5AB1 85 66                 sta   RgnPtrB+2
1219 5AB3 60                    rts   
1220 5AB4
1221 5AB4
1222 5AB4                       ENDP 
1223 5AB4
1224 5AB4              ****************************************************************
1225 5AB4              *
1226 5AB4              * UnlockB
1227 5AB4              *
1228 5AB4              ****************************************************************
1229 5AB4                       EXPORT UnlockB 
1230 5AB4              UnlockB  PROC 
1231 5AB4
1232 5AB4 A0 04 00              ldy   #4                       ; unlock it
1233 5AB7 B7 60                 lda   [RgnHandleB],y
1234 5AB9 29 FF 7F              and   #$7FFF
1235 5ABC 97 60                 sta   [RgnHandleB],y
1236 5ABE 60                    rts   
1237 5ABF
1238 5ABF
1239 5ABF                       ENDP 
1240 5ABF
1241 5ABF
1242 5ABF              ****************************************************************
1243 5ABF              *
1244 5ABF              * DeRefC
1245 5ABF              *
1246 5ABF              ****************************************************************
1247 5ABF                       EXPORT DeRefC 
1248 5ABF              DeRefC   PROC 
1249 5ABF
1250 5ABF A0 04 00              ldy   #4                       ; lock it
1251 5AC2 B7 70                 lda   [RgnHandleC],y
1252 5AC4 09 00 80              ora   #$8000
1253 5AC7 97 70                 sta   [RgnHandleC],y
1254 5AC9
1255 5AC9 A7 70                 lda   [RgnHandleC]             ; deref it.
1256 5ACB 85 74                 sta   RgnPtrC
1257 5ACD A0 02 00              ldy   #2
1258 5AD0 B7 70                 lda   [RgnHandleC],y
1259 5AD2 85 76                 sta   RgnPtrC+2
1260 5AD4 60                    rts   
1261 5AD5
1262 5AD5
1263 5AD5                       ENDP 
1264 5AD5
1265 5AD5              ****************************************************************
1266 5AD5              *
1267 5AD5              * UnlockC
1268 5AD5              *
1269 5AD5              ****************************************************************
1270 5AD5                       EXPORT UnlockC 
1271 5AD5              UnlockC  PROC 
1272 5AD5
1273 5AD5 A0 04 00              ldy   #4                       ; unlock it
1274 5AD8 B7 70                 lda   [RgnHandleC],y
1275 5ADA 29 FF 7F              and   #$7FFF
1276 5ADD 97 70                 sta   [RgnHandleC],y
1277 5ADF 60                    rts   
1278 5AE0
1279 5AE0
1280 5AE0                       ENDP 
1281 5AE0
1282 5AE0
1283 5AE0              ****************************************************************
1284 5AE0              *
1285 5AE0              * ResizeA
1286 5AE0              *
1287 5AE0              ****************************************************************
1288 5AE0                       EXPORT ResizeA 
1289 5AE0              ResizeA  PROC 
1290 5AE0
1291 5AE0 A2 50 00              ldx   #RgnHandleA
1292 5AE3 20 3B 5B              jsr   ResizeHandle
1293 5AE6 B0 06                 bcs   error
1294 5AE8 85 54                 sta   RgnPtrA
1295 5AEA 86 56                 stx   RgnPtrA+2
1296 5AEC A7 54                 lda   [RgnPtrA]
1297 5AEE 60           error    rts   
1298 5AEF
1299 5AEF                       ENDP 
1300 5AEF
1301 5AEF              ****************************************************************
1302 5AEF              *
1303 5AEF              * ResizeB
1304 5AEF              *
1305 5AEF              ****************************************************************
1306 5AEF                       EXPORT ResizeB 
1307 5AEF              ResizeB  PROC 
1308 5AEF A2 60 00              ldx   #RgnHandleB
1309 5AF2 20 3B 5B              jsr   ResizeHandle
1310 5AF5 B0 06                 bcs   error
1311 5AF7 85 64                 sta   RgnPtrB
1312 5AF9 86 66                 stx   RgnPtrB+2
1313 5AFB A7 64                 lda   [RgnPtrB]
1314 5AFD 60           error    rts   
1315 5AFE
1316 5AFE                       ENDP 
1317 5AFE
1318 5AFE
1319 5AFE              ****************************************************************
1320 5AFE              *
1321 5AFE              * ResizeC
1322 5AFE              *
1323 5AFE              ****************************************************************
1324 5AFE                       EXPORT ResizeC 
1325 5AFE              ResizeC  PROC 
1326 5AFE A2 70 00              ldx   #RgnHandleC
1327 5B01 20 3B 5B              jsr   ResizeHandle
1328 5B04 B0 06                 bcs   error
1329 5B06 85 74                 sta   RgnPtrC
1330 5B08 86 76                 stx   RgnPtrC+2
1331 5B0A A7 74                 lda   [RgnPtrC]                ; get size back in a
1332 5B0C 60           error    rts   
1333 5B0D                       ENDP 
1334 5B0D
1335 5B0D
1336 5B0D              ****************************************************************
1337 5B0D              *
1338 5B0D              * DerefHandle
1339 5B0D              *
1340 5B0D              ****************************************************************
1341 5B0D                       EXPORT DerefHandle 
1342 5B0D              DerefHandle PROC 
1343 5B0D
1344 5B0D              * enter with zero page offset to src in X
1345 5B0D
1346 5B0D              * sample usage:
1347 5B0D              *
1348 5B0D              *     ldx #RgnHandleA
1349 5B0D              *     jsr DerefHandle
1350 5B0D              *     sta RgnPtrA
1351 5B0D              *     stx RgnPtrA+2
1352 5B0D
1353 5B0D B5 00                 lda   0,x
1354 5B0F 85 2A                 sta   Temp
1355 5B11 B5 02                 lda   2,x
1356 5B13 85 2C                 sta   Temp+2
1357 5B15
1358 5B15                       EXPORT QuickDeref 
1359 5B15              QuickDeref                              ;       ; enter here if Temp has handle already
1360 5B15
1361 5B15              * sample usage:
1362 5B15              *     jsr QuickDeref	; Temp still has handle
1363 5B15              *     sta RgnPtrA
1364 5B15              *     stx RgnPtrA+2
1365 5B15
1366 5B15              * handle is in Temp; lock it down
1367 5B15
1368 5B15 A0 04 00              ldy   #4
1369 5B18 B7 2A                 lda   [Temp],y
1370 5B1A 09 00 80              ora   #$8000
1371 5B1D 97 2A                 sta   [Temp],y
1372 5B1F
1373 5B1F              * dereference it, leaving low word in A and high word in X
1374 5B1F
1375 5B1F A0 02 00              ldy   #2
1376 5B22 B7 2A                 lda   [Temp],y
1377 5B24 AA                    tax   
1378 5B25 A7 2A                 lda   [Temp]
1379 5B27 60                    rts   
1380 5B28
1381 5B28                       ENDP 
1382 5B28
1383 5B28              ****************************************************************
1384 5B28              *
1385 5B28              * Procedure UnlockHandle
1386 5B28              *
1387 5B28              ****************************************************************
1388 5B28                       EXPORT UnlockHandle 
1389 5B28              UnlockHandle PROC 
1390 5B28
1391 5B28              * enter with zero page offset to handle in x
1392 5B28
1393 5B28              * Sample usage
1394 5B28              *
1395 5B28              *     ldx #RgnHandleA
1396 5B28              *     jsr UnlockHandle
1397 5B28
1398 5B28 B5 00                 lda   0,x
1399 5B2A 85 2A                 sta   Temp
1400 5B2C B5 02                 lda   2,x
1401 5B2E 85 2C                 sta   Temp+2
1402 5B30
1403 5B30              * unlock it
1404 5B30
1405 5B30 A0 04 00              ldy   #4
1406 5B33 B7 2A                 lda   [Temp],y
1407 5B35 29 FF 7F              and   #$7FFF
1408 5B38 97 2A                 sta   [Temp],y
1409 5B3A
1410 5B3A              * leave with Temp still holding the handle so related routines
1411 5B3A              * can use it
1412 5B3A
1413 5B3A 60                    rts   
1414 5B3B
1415 5B3B                       ENDP 
1416 5B3B
1417 5B3B              ****************************************************************
1418 5B3B              *
1419 5B3B              * ResizeHandle
1420 5B3B              *
1421 5B3B              ****************************************************************
1422 5B3B                       EXPORT ResizeHandle 
1423 5B3B              ResizeHandle PROC 
1424 5B3B
1425 5B3B              * enter with pointer to handle on zero page in x
1426 5B3B
1427 5B3B              * Sample usage
1428 5B3B              *
1429 5B3B              *     lda NewHandleSize
1430 5B3B              *     ldx #RgnHandleA
1431 5B3B              *     jsr ResizeHandle
1432 5B3B              *     sta RgnPtrA
1433 5B3B              *     stx RgnPtrA+2
1434 5B3B
1435 5B3B 48                    pha                            ; push size (02)
1436 5B3C F4 00 00              pea   0                        ; push 0 for high word of size (04)
1437 5B3F 48                    pha                            ; push low word of size (06)
1438 5B40 20 28 5B              jsr   UnlockHandle             ; pass X as pointer
1439 5B43
1440 5B43              * UnlockHandle leaves a copy of the handle in Temp for us.  Long word size
1441 5B43              * is still on the stack
1442 5B43
1443 5B43 D4 2C                 pei   Temp+2                   ; push handle high (08)
1444 5B45 D4 2A                 pei   Temp                     ; push handle low (0A)
1445 5B47 A2 02 19 22           _SetHandleSize                 ; handle size is at top of stack (02)
1446 5B4E B0 0D                 bcs   Error                    ; we found an error, A & X are invalid
1447 5B50
1448 5B50                       EXPORT NewEntry 
1449 5B50              NewEntry                                ; 
1450 5B50
1451 5B50 20 15 5B              jsr   QuickDeref               ; handle still in Temp, redereference it
1452 5B53 85 2A                 sta   Temp                     ; pointer is in A & X
1453 5B55 86 2C                 stx   Temp+2
1454 5B57 68                    pla                            ; get size back (00)
1455 5B58 87 2A                 sta   [Temp]                   ; set size for regions, invpt buffers
1456 5B5A A5 2A                 lda   Temp                     ; pointer is in A & X
1457 5B5C 60                    rts   
1458 5B5D
1459 5B5D 7A           Error    ply                            ; error in A, carry is still set (00)
1460 5B5E A2 FF FF              ldx   #$FFFF                   ; invalidate pointer
1461 5B61 60                    rts   
1462 5B62
1463 5B62                       ENDP 
1464 5B62
1465 5B62              ****************************************************************
1466 5B62              *
1467 5B62              * GetNewHandle
1468 5B62              *
1469 5B62              ****************************************************************
1470 5B62                       EXPORT GetNewHandle 
1471 5B62              GetNewHandle PROC 
1472 5B62
1473 5B62              *              using RegionData
1474 5B62              *              using CoreData
1475 5B62
1476 5B62              * It accepts a size in A and an offset to the zero page handle variable
1477 5B62              * in X.  Upon return it has initialized a new handle, dereferenced it,
1478 5B62              * and set the first two bytes of the handle data to the length of the
1479 5B62              * handle, which is what regions and buffers want.  Because it sets the
1480 5B62              * length it assumes the size (in A) will never be less than 2 bytes.
1481 5B62              * It puts a copy of the new handle into the location pointed at by X.
1482 5B62              * The dereferenced pointer is returned in A and X.
1483 5B62
1484 5B62 48                    pha                            ; save size
1485 5B63 DA                    phx                            ; save offset
1486 5B64
1487 5B64 A6 0A                 ldx   UserID
1488 5B66 A0 00 00              ldy   #RgnAttributes
1489 5B69 20 3B 13              jsr   SpecialNewHandle
1490 5B6C B0 0D                 bcs   HandleError              ; if error, clean up
1491 5B6E
1492 5B6E 86 2A                 stx   Temp
1493 5B70 84 2C                 sty   Temp+2
1494 5B72
1495 5B72 FA                    plx                            ; get offset back
1496 5B73 94 02                 sty   2,x                      ; save high word to real handle
1497 5B75 A4 2A                 ldy   Temp                     ; get low word back
1498 5B77 94 00                 sty   0,x                      ; save low word to real handle
1499 5B79
1500 5B79              * The size is still on the stack.  This now looks like we've just resized
1501 5B79              * a handle, so branch upwards and use the code we've already written.
1502 5B79
1503 5B79 80 D5                 bra   NewEntry                 ; pointer will come back in A and X
1504 5B7B
1505 5B7B 7A           HandleError ply                         ; discard offset
1506 5B7C 7A                    ply                            ; discard size
1507 5B7D 60                    rts   
1508 5B7E
1509 5B7E                       ENDP 
1510 5B7E              ;                copy regions/setup
1511 5B7E              ****************************************************************
1512 5B7E              *
1513 5B7E              * SetUpPortRegions
1514 5B7E              *
1515 5B7E              * This is the procedure called by the object drawing routines
1516 5B7E              * to dereference and lock the clip and vis regions and put
1517 5B7E              * the "Fake" wideopen region into region C
1518 5B7E              *
1519 5B7E              * 2/24/89           Mensch
1520 5B7E              *
1521 5B7E              * Unwind the ClipToRgnA and VisToRgnB calls. total of 40 cycles.. not enough yet...
1522 5B7E              *
1523 5B7E              ****************************************************************
1524 5B7E                       EXPORT iSetUpPortRegions 
1525 5B7E              iSetUpPortRegions PROC 
1526 5B7E              *              using E0Vectors
1527 5B7E
1528 5B7E              ;	jsr	ClipToRgnA
1529 5B7E              ;	jsr	VisToRgnB
1530 5B7E
1531 5B7E A0 18 00              ldy   #o_ClipRgn
1532 5B81 B7 24                 lda   [PortRef],y
1533 5B83 85 50                 sta   RgnHandleA
1534 5B85 A0 1A 00              ldy   #o_ClipRgn+2
1535 5B88 B7 24                 lda   [PortRef],y
1536 5B8A 85 52                 sta   RgnHandleA+2
1537 5B8C A0 1C 00              ldy   #o_VisRgn
1538 5B8F B7 24                 lda   [PortRef],y
1539 5B91 85 60                 sta   RgnHandleB
1540 5B93 A0 1E 00              ldy   #o_VisRgn+2
1541 5B96 B7 24                 lda   [PortRef],y
1542 5B98 85 62                 sta   RgnHandleB+2
1543 5B9A
1544 5B9A A0 04 00              ldy   #4                       ; lock it
1545 5B9D B7 60                 lda   [RgnHandleB],y
1546 5B9F 09 00 80              ora   #$8000
1547 5BA2 97 60                 sta   [RgnHandleB],y
1548 5BA4
1549 5BA4 B7 50                 lda   [RgnHandleA],y
1550 5BA6 09 00 80              ora   #$8000
1551 5BA9 97 50                 sta   [RgnHandleA],y
1552 5BAB
1553 5BAB A7 60                 lda   [RgnHandleB]             ; deref it.
1554 5BAD 85 64                 sta   RgnPtrB
1555 5BAF A0 02 00              ldy   #2
1556 5BB2 B7 60                 lda   [RgnHandleB],y
1557 5BB4 85 66                 sta   RgnPtrB+2
1558 5BB6 A7 50                 lda   [RgnHandleA]             ; deref it.
1559 5BB8 85 54                 sta   RgnPtrA
1560 5BBA B7 50                 lda   [RgnHandleA],y
1561 5BBC 85 56                 sta   RgnPtrA+2
1562 5BBE
1563 5BBE 22 A4 1E E0           jsl   SetUpScanPtrs
1564 5BC2
1565 5BC2 6B                    rtl   
1566 5BC3
1567 5BC3                       ENDP 
1568 5BC3
1569 5BC3
1570 5BC3              ****************************************************************
1571 5BC3              *
1572 5BC3              * Region Freeing Routines
1573 5BC3              *
1574 5BC3              * This is the procedure called by the object drawing routines
1575 5BC3              * to unlock the clip and vis regions.
1576 5BC3              *
1577 5BC3              ****************************************************************
1578 5BC3                       EXPORT iFree3Regions 
1579 5BC3              iFree3Regions PROC 
1580 5BC3 20 D5 5A              jsr   UnlockC
1581 5BC6
1582 5BC6                       EXPORT iFree2Regions 
1583 5BC6              iFree2Regions                           ; 
1584 5BC6 20 B4 5A              jsr   UnlockB
1585 5BC9
1586 5BC9                       EXPORT iFree1Region 
1587 5BC9              iFree1Region                            ; 
1588 5BC9 20 93 5A              jsr   UnlockA
1589 5BCC
1590 5BCC 22 5B 5C FE           jsl   UnlockBufferHandle
1591 5BD0 6B                    rtl   
1592 5BD1
1593 5BD1
1594 5BD1
1595 5BD1              ***********************************************************
1596 5BD1              *
1597 5BD1              iFreePortRegions PROC Export 
1598 5BD1              *
1599 5BD1              * This unlocks region a, b and the buffer handle.
1600 5BD1              *
1601 5BD1              *
1602 5BD1              *
1603 5BD1              * External Refs:
1604 5BD1              *
1605 5BD1              * Entry Points:
1606 5BD1              *
1607 5BD1              * Change History
1608 5BD1              *
1609 5BD1              * 25 Feb 89         Mensch
1610 5BD1              *
1611 5BD1              * Spend a little more ROM space to save even more cycles per
1612 5BD1              * qdcall. This one should save : 64 cycles and cost 25 bytes...
1613 5BD1              *
1614 5BD1              ***********************************************************
1615 5BD1 A0 04 00              ldy   #4
1616 5BD4 B7 50                 lda   [RgnHandleA],y
1617 5BD6 29 FF 7F              and   #$7FFF
1618 5BD9 97 50                 sta   [RgnHandleA],y
1619 5BDB B7 60                 lda   [RgnHandleB],y
1620 5BDD 29 FF 7F              and   #$7FFF
1621 5BE0 97 60                 sta   [RgnHandleB],y
1622 5BE2 B7 3C                 lda   [BufferHandle],y
1623 5BE4 29 FF 7F              and   #$7FFF
1624 5BE7 97 3C                 sta   [BufferHandle],y
1625 5BE9 6B                    rtl   
1626 5BEA                       ENDP 
1627 5BEA
1628 5BEA
1629 5BEA
1630 5BEA
1631 5BEA              ****************************************************************
1632 5BEA              *
1633 5BEA              * ClipToRgnA
1634 5BEA              *
1635 5BEA              * An internal routine to copy the handle to the ClipRgn in
1636 5BEA              * the current port to RgnHandleA on zero page and then to
1637 5BEA              * Dereference it and lock it.
1638 5BEA              *
1639 5BEA              ****************************************************************
1640 5BEA                       EXPORT ClipToRgnA 
1641 5BEA              ClipToRgnA PROC 
1642 5BEA              *              using CoreData
1643 5BEA
1644 5BEA A0 18 00              ldy   #o_ClipRgn
1645 5BED B7 24                 lda   [PortRef],y
1646 5BEF 85 50                 sta   RgnHandleA
1647 5BF1 C8                    iny   
1648 5BF2 C8                    iny   
1649 5BF3 B7 24                 lda   [PortRef],y
1650 5BF5 85 52                 sta   RgnHandleA+2
1651 5BF7 82 83 FE              brl   DeRefA
1652 5BFA              ;	rts
1653 5BFA
1654 5BFA                       ENDP 
1655 5BFA
1656 5BFA              ****************************************************************
1657 5BFA              *
1658 5BFA              * VisToRgnB
1659 5BFA              *
1660 5BFA              * An internal routine to copy the handle to the VisRgn in
1661 5BFA              * the current port to RgnHandleB on zero page and then to
1662 5BFA              * Dereference it and lock it.
1663 5BFA              *
1664 5BFA              ****************************************************************
1665 5BFA                       EXPORT VisToRgnB 
1666 5BFA              VisToRgnB PROC 
1667 5BFA              *              using CoreData
1668 5BFA
1669 5BFA A0 1C 00              ldy   #o_VisRgn
1670 5BFD B7 24                 lda   [PortRef],y
1671 5BFF 85 60                 sta   RgnHandleB
1672 5C01 C8                    iny   
1673 5C02 C8                    iny   
1674 5C03 B7 24                 lda   [PortRef],y
1675 5C05 85 62                 sta   RgnHandleB+2
1676 5C07 82 94 FE              brl   DeRefB
1677 5C0A              ;	rts
1678 5C0A
1679 5C0A                       ENDP 
1680 5C0A
1681 5C0A
1682 5C0A              ****************************************************************
1683 5C0A              *
1684 5C0A              * SetUpScanPtrs
1685 5C0A              *
1686 5C0A              * An internal routine to set up the following pointers.
1687 5C0A              *
1688 5C0A              *     ScanPtrA
1689 5C0A              *     ScanPtrB
1690 5C0A              *     ScanPtrC
1691 5C0A              *     ScanMaskRef
1692 5C0A              *
1693 5C0A              * These are obtained by dereferencing the BufferHandle and
1694 5C0A              * dividing up the buffer it points to.
1695 5C0A              *
1696 5C0A              ****************************************************************
1697 5C0A                       EXPORT iSetUpScanPtrs 
1698 5C0A              iSetUpScanPtrs PROC 
1699 5C0A              *              using RgnStateDATA
1700 5C0A
1701 5C0A A5 3C                 lda   BufferHandle
1702 5C0C A6 3E                 ldx   BufferHandle+2
1703 5C0E 20 58 5A              jsr   DerefAndLock
1704 5C11
1705 5C11 85 4C                 sta   ScanMaskRef
1706 5C13 86 4E                 stx   ScanMaskRef+2
1707 5C15
1708 5C15 18                    clc   
1709 5C16 65 28                 adc   MaxWidth
1710 5C18 85 5C                 sta   ScanPtrA
1711 5C1A              ; Changed
1712 5C1A 90 01                 bcc   @1
1713 5C1C E8                    inx   
1714 5C1D 86 5E        @1       stx   ScanPtrA+2
1715 5C1F
1716 5C1F              ; Saves 2 bytes and 4 cycles
1717 5C1F              ;	lda	ScanMaskRef+2
1718 5C1F              ;	adc	#0
1719 5C1F              ;	sta	ScanPtrA+2
1720 5C1F
1721 5C1F A8                    tay                            ; save <A> for a second...
1722 5C20 A5 28                 lda   MaxWidth
1723 5C22 4A                    lsr   a
1724 5C23 48                    pha                            ; Save this on the stack for a second...
1725 5C24 98                    tya                            ; get ScanPtrA back in <A> and <X>
1726 5C25
1727 5C25              ; <A><X> contain ScanPtrA
1728 5C25 18                    clc   
1729 5C26 63 01                 adc   1,s                      ; add maxWidth/2
1730 5C28 85 6C                 sta   ScanPtrB
1731 5C2A 90 01                 bcc   @2
1732 5C2C E8                    inx   
1733 5C2D 86 6E        @2       stx   ScanPtrB+2
1734 5C2F
1735 5C2F              ; <A><X> contain ScanPtrB
1736 5C2F 18                    clc   
1737 5C30 63 01                 adc   1,s                      ; add maxWidth/2
1738 5C32 85 7C                 sta   ScanPtrC
1739 5C34 90 01                 bcc   @3
1740 5C36 E8                    inx   
1741 5C37 86 7E        @3       stx   ScanPtrC+2
1742 5C39
1743 5C39              ; <A><X> contain ScanPtrC
1744 5C39
1745 5C39 18                    clc   
1746 5C3A 63 01                 adc   1,s
1747 5C3C 85 58                 sta   StatePtrA
1748 5C3E 90 01                 bcc   @4
1749 5C40 E8                    inx   
1750 5C41 86 5A        @4       stx   StatePtrA+2
1751 5C43
1752 5C43              ; <A><X> contain StatePtrA
1753 5C43 18                    clc   
1754 5C44 69 20 00              adc   #StateRecSize
1755 5C47 85 68                 sta   StatePtrB
1756 5C49 90 01                 bcc   @5
1757 5C4B E8                    inx   
1758 5C4C 86 6A        @5       stx   StatePtrB+2
1759 5C4E
1760 5C4E              ; <A><X> contains StatePtrB
1761 5C4E 18                    clc   
1762 5C4F 69 20 00              adc   #StateRecSize
1763 5C52 85 78                 sta   StatePtrC
1764 5C54 90 01                 bcc   @6
1765 5C56 E8                    inx   
1766 5C57 86 7A        @6       stx   StatePtrC+2
1767 5C59 68                    pla                            ; strip off MaxWidth/2
1768 5C5A
1769 5C5A 6B                    rtl   
1770 5C5B
1771 5C5B                       ENDP 
1772 5C5B
1773 5C5B
1774 5C5B              ****************************************************************
1775 5C5B              *
1776 5C5B              * UnlockBufferHandle
1777 5C5B              *
1778 5C5B              *
1779 5C5B              ****************************************************************
1780 5C5B                       EXPORT UnlockBufferHandle 
1781 5C5B              UnlockBufferHandle PROC 
1782 5C5B
1783 5C5B A5 3C                 lda   BufferHandle
1784 5C5D A6 3E                 ldx   BufferHandle+2
1785 5C5F 20 6E 5A              jsr   UnlockMem
1786 5C62
1787 5C62 6B                    rtl   
1788 5C63
1789 5C63                       ENDP 
1790 5C63              ;                COPY regions/toplevel
1791 5C63              ****************************************************************
1792 5C63              *
1793 5C63              * Init3Regions
1794 5C63              *
1795 5C63              * This is the procedure called by the object drawing routines
1796 5C63              * to get ready to clip to three aribrary regions.
1797 5C63              *
1798 5C63              * The three regions are already dereferenced and locked.  The
1799 5C63              * pointers are in RgnPtrA, RgnPtrB and RgnPtrC.
1800 5C63              *
1801 5C63              * For each of the three regions, the procedure calls InitRgn
1802 5C63              * which sets up the state record for the region.
1803 5C63              *
1804 5C63              * Modifications:
1805 5C63              * 12/2/87      GCP     Added InitUp3Rgns to handle cases where we
1806 5C63              *                      want to seek up through a region
1807 5C63              ****************************************************************
1808 5C63                       EXPORT iInit3Regions 
1809 5C63              iInit3Regions PROC 
1810 5C63              *              using E0Vectors
1811 5C63
1812 5C63              ;---------------------------------------------------
1813 5C63              ;
1814 5C63              ; First I initialize NonRectRegions and set up
1815 5C63              ; MinX, MaxX and LeftH
1816 5C63              ;
1817 5C63 64 A4                 stz   NonRectRegions
1818 5C65
1819 5C65 A5 02                 lda   MinRect+2
1820 5C67 85 90                 sta   MinX
1821 5C69 A5 06                 lda   MinRect+6
1822 5C6B 85 92                 sta   MaxX
1823 5C6D A5 16                 lda   BoundsRect+2
1824 5C6F 85 94                 sta   LeftH
1825 5C71
1826 5C71              ;---------------------------------------------------
1827 5C71              ;
1828 5C71              ; Now initialize each of the three state records.
1829 5C71              ;
1830 5C71 A5 54 85 80           MoveLong RgnPtrA,RgnPtr 
1831 5C79 A5 5C 85 88           MoveLong ScanPtrA,ScanPtr 
1832 5C81 A5 58 85 84           MoveLong StatePtrA,StatePtr 
1833 5C89 22 D4 1E E0           jsl   InitRgn
1834 5C8D
1835 5C8D A5 64 85 80           MoveLong RgnPtrB,RgnPtr 
1836 5C95 A5 6C 85 88           MoveLong ScanPtrB,ScanPtr 
1837 5C9D A5 68 85 84           MoveLong StatePtrB,StatePtr 
1838 5CA5 22 D4 1E E0           jsl   InitRgn
1839 5CA9
1840 5CA9 A5 74 85 80           MoveLong RgnPtrC,RgnPtr 
1841 5CB1 A5 7C 85 88           MoveLong ScanPtrC,ScanPtr 
1842 5CB9 A5 78 85 84           MoveLong StatePtrC,StatePtr 
1843 5CC1 22 D4 1E E0           jsl   InitRgn
1844 5CC5
1845 5CC5
1846 5CC5 6B                    rtl   
1847 5CC6
1848 5CC6                       ENDP 
1849 5CC6
1850 5CC6
1851 5CC6
1852 5CC6
1853 5CC6
1854 5CC6                       EXPORT InitUp3Rgns 
1855 5CC6              InitUp3Rgns PROC 
1856 5CC6              *              using E0Vectors
1857 5CC6
1858 5CC6              ;---------------------------------------------------
1859 5CC6              ;
1860 5CC6              ; First I initialize NonRectRegions and set up
1861 5CC6              ; MinX, MaxX and LeftH
1862 5CC6              ;
1863 5CC6 64 A4                 stz   NonRectRegions
1864 5CC8
1865 5CC8 A5 02                 lda   MinRect+2
1866 5CCA 85 90                 sta   MinX
1867 5CCC A5 06                 lda   MinRect+6
1868 5CCE 85 92                 sta   MaxX
1869 5CD0 A5 16                 lda   BoundsRect+2
1870 5CD2 85 94                 sta   LeftH
1871 5CD4
1872 5CD4              ;---------------------------------------------------
1873 5CD4              ;
1874 5CD4              ; Now initialize each of the three state records.
1875 5CD4              ;
1876 5CD4 A5 54 85 80           MoveLong RgnPtrA,RgnPtr 
1877 5CDC A5 5C 85 88           MoveLong ScanPtrA,ScanPtr 
1878 5CE4 A5 58 85 84           MoveLong StatePtrA,StatePtr 
1879 5CEC 22 E1 5E FE           jsl   InitRgnUp
1880 5CF0
1881 5CF0 A5 64 85 80           MoveLong RgnPtrB,RgnPtr 
1882 5CF8 A5 6C 85 88           MoveLong ScanPtrB,ScanPtr 
1883 5D00 A5 68 85 84           MoveLong StatePtrB,StatePtr 
1884 5D08 22 E1 5E FE           jsl   InitRgnUp
1885 5D0C
1886 5D0C A5 74 85 80           MoveLong RgnPtrC,RgnPtr 
1887 5D14 A5 7C 85 88           MoveLong ScanPtrC,ScanPtr 
1888 5D1C A5 78 85 84           MoveLong StatePtrC,StatePtr 
1889 5D24 22 E1 5E FE           jsl   InitRgnUp
1890 5D28
1891 5D28
1892 5D28 6B                    rtl   
1893 5D29
1894 5D29                       ENDP 
1895 5D29
1896 5D29
1897 5D29              ****************************************************************
1898 5D29              *
1899 5D29              * Seek3Regions
1900 5D29              *
1901 5D29              * This is the procedure that builds the scan line clip buffer
1902 5D29              * used by the slab and slice routines.
1903 5D29              *
1904 5D29              * This buffer is made by combining three scan line clip buffers
1905 5D29              * for each of the three regions being clipped to.
1906 5D29              *
1907 5D29              ****************************************************************
1908 5D29                       EXPORT iSeek3Regions 
1909 5D29              iSeek3Regions PROC 
1910 5D29              *              using RgnStateData
1911 5D29              *              using E0Vectors
1912 5D29
1913 5D29 64 9E                 stz   BufChanged               ; assume none change
1914 5D2B
1915 5D2B A5 58 85 84           MoveLong StatePtrA,StatePtr    ; Seek along a
1916 5D33 22 D8 1E E0           jsl   SeekRgn
1917 5D37 F0 02                 beq   NoChangeA
1918 5D39 E6 9E                 inc   BufChanged               ; it changed
1919 5D3B
1920 5D3B A5 68 85 84  NoChangeA MoveLong StatePtrB,StatePtr   ; Seek along B
1921 5D43 22 D8 1E E0           jsl   SeekRgn
1922 5D47 F0 02                 beq   NoChangeB
1923 5D49 E6 9E                 inc   BufChanged               ; it changed
1924 5D4B
1925 5D4B A5 78 85 84  NoChangeB MoveLong StatePtrC,StatePtr   ; Seek along C
1926 5D53 22 D8 1E E0           jsl   SeekRgn
1927 5D57 F0 02                 beq   NoChangeC
1928 5D59 E6 9E                 inc   BufChanged               ; it changed
1929 5D5B
1930 5D5B A5 9E        NoChangeC lda   BufChanged              ; did any change?
1931 5D5D F0 07                 beq   AllDone                  ; no, all done.
1932 5D5F
1933 5D5F
1934 5D5F              ;----------------------------------------------
1935 5D5F              ;
1936 5D5F              ; At least one changed so we have to rebuild
1937 5D5F              ; the master scanmask buffer.
1938 5D5F              ;
1939 5D5F 20 1D 5E              jsr   JoinSetUp
1940 5D62 22 E4 1E E0           jsl   Join3Buffers
1941 5D66
1942 5D66 6B           AllDone  rtl   
1943 5D67
1944 5D67                       ENDP 
1945 5D67
1946 5D67
1947 5D67              ****************************************************************
1948 5D67              *
1949 5D67              * Init2Regions
1950 5D67              *
1951 5D67              * This is the procedure called by the object drawing routines
1952 5D67              * to get ready to clip to two aribrary regions.
1953 5D67              *
1954 5D67              * The two regions are already dereferenced and locked.  The
1955 5D67              * pointers are in RgnPtrA and RgnPtrB.
1956 5D67              *
1957 5D67              * For each region, the this procedure calls InitRgn
1958 5D67              * which sets up the state record for the region.
1959 5D67              *
1960 5D67              ****************************************************************
1961 5D67                       EXPORT iInit2Regions 
1962 5D67              iInit2Regions PROC 
1963 5D67              *              using E0Vectors
1964 5D67
1965 5D67              ;---------------------------------------------------
1966 5D67              ;
1967 5D67              ; First I initialize NonRectRegions and set up
1968 5D67              ; MinX, MaxX and LeftH
1969 5D67              ;
1970 5D67 64 A4                 stz   NonRectRegions
1971 5D69
1972 5D69 A5 02                 lda   MinRect+2
1973 5D6B 85 90                 sta   MinX
1974 5D6D A5 06                 lda   MinRect+6
1975 5D6F 85 92                 sta   MaxX
1976 5D71 A5 16                 lda   BoundsRect+2
1977 5D73 85 94                 sta   LeftH
1978 5D75
1979 5D75              ;---------------------------------------------------
1980 5D75              ;
1981 5D75              ; Now initialize each of the two state records.
1982 5D75              ;
1983 5D75 A5 54 85 80           MoveLong RgnPtrA,RgnPtr 
1984 5D7D A5 5C 85 88           MoveLong ScanPtrA,ScanPtr 
1985 5D85 A5 58 85 84           MoveLong StatePtrA,StatePtr 
1986 5D8D 22 D4 1E E0           jsl   InitRgn
1987 5D91
1988 5D91 A5 64 85 80           MoveLong RgnPtrB,RgnPtr 
1989 5D99 A5 6C 85 88           MoveLong ScanPtrB,ScanPtr 
1990 5DA1 A5 68 85 84           MoveLong StatePtrB,StatePtr 
1991 5DA9 22 D4 1E E0           jsl   InitRgn
1992 5DAD
1993 5DAD 6B                    rtl   
1994 5DAE
1995 5DAE                       ENDP 
1996 5DAE
1997 5DAE
1998 5DAE
1999 5DAE              ****************************************************************
2000 5DAE              *
2001 5DAE              * Seek2Regions
2002 5DAE              *
2003 5DAE              * This is the procedure that builds the scan line clip buffer
2004 5DAE              * used by the slab and slice routines.
2005 5DAE              *
2006 5DAE              * This buffer is made by combining scan line clip buffers
2007 5DAE              * for each of the two regions being clipped to.
2008 5DAE              *
2009 5DAE              ****************************************************************
2010 5DAE                       EXPORT iSeek2Regions 
2011 5DAE              iSeek2Regions PROC 
2012 5DAE              *              using RgnStateData
2013 5DAE              *              using E0Vectors
2014 5DAE
2015 5DAE 64 9E                 stz   BufChanged               ; assume none change
2016 5DB0
2017 5DB0 A5 58 85 84           MoveLong StatePtrA,StatePtr    ; Seek along a
2018 5DB8 22 D8 1E E0           jsl   SeekRgn
2019 5DBC F0 02                 beq   NoChangeA
2020 5DBE E6 9E                 inc   BufChanged               ; it changed
2021 5DC0
2022 5DC0 A5 68 85 84  NoChangeA MoveLong StatePtrB,StatePtr   ; Seek along B
2023 5DC8 22 D8 1E E0           jsl   SeekRgn
2024 5DCC F0 02                 beq   NoChangeB
2025 5DCE E6 9E                 inc   BufChanged               ; it changed
2026 5DD0
2027 5DD0 A5 9E        NoChangeB lda   BufChanged              ; did any change?
2028 5DD2 F0 07                 beq   AllDone                  ; no, all done.
2029 5DD4
2030 5DD4
2031 5DD4              ;----------------------------------------------
2032 5DD4              ;
2033 5DD4              ; At least one changed so we have to rebuild
2034 5DD4              ; the master scanmask buffer.
2035 5DD4              ;
2036 5DD4 20 1D 5E              jsr   JoinSetUp
2037 5DD7 22 E0 1E E0           jsl   Join2Buffers
2038 5DDB
2039 5DDB 6B           AllDone  rtl   
2040 5DDC
2041 5DDC                       ENDP 
2042 5DDC
2043 5DDC
2044 5DDC
2045 5DDC
2046 5DDC
2047 5DDC              ****************************************************************
2048 5DDC              *
2049 5DDC              * Init1Region
2050 5DDC              *
2051 5DDC              * This is the procedure called by the object drawing routines
2052 5DDC              * to get ready to clip to one aribtrary region.
2053 5DDC              *
2054 5DDC              * The region is already dereferenced and locked.  The
2055 5DDC              * pointer is in RgnPtrA.
2056 5DDC              *
2057 5DDC              ****************************************************************
2058 5DDC                       EXPORT iInit1Region 
2059 5DDC              iInit1Region PROC 
2060 5DDC              *              using E0Vectors
2061 5DDC
2062 5DDC              ;---------------------------------------------------
2063 5DDC              ;
2064 5DDC              ; First I initialize NonRectRegions and set up
2065 5DDC              ; MinX, MaxX and LeftH
2066 5DDC              ;
2067 5DDC 64 A4                 stz   NonRectRegions
2068 5DDE
2069 5DDE A5 02                 lda   MinRect+2
2070 5DE0 85 90                 sta   MinX
2071 5DE2 A5 06                 lda   MinRect+6
2072 5DE4 85 92                 sta   MaxX
2073 5DE6 A5 16                 lda   BoundsRect+2
2074 5DE8 85 94                 sta   LeftH
2075 5DEA
2076 5DEA              ;---------------------------------------------------
2077 5DEA              ;
2078 5DEA              ; Now initialize the state record.
2079 5DEA              ;
2080 5DEA A5 54 85 80           MoveLong RgnPtrA,RgnPtr 
2081 5DF2 A5 5C 85 88           MoveLong ScanPtrA,ScanPtr 
2082 5DFA A5 58 85 84           MoveLong StatePtrA,StatePtr 
2083 5E02 22 D4 1E E0           jsl   InitRgn
2084 5E06
2085 5E06 6B                    rtl   
2086 5E07
2087 5E07                       ENDP 
2088 5E07
2089 5E07
2090 5E07
2091 5E07              ****************************************************************
2092 5E07              *
2093 5E07              * Seek1Region
2094 5E07              *
2095 5E07              * This is the procedure that builds the scan line clip buffer
2096 5E07              * used by the slab and slice routines.
2097 5E07              *
2098 5E07              * This buffer is made from the scan line clip buffer of
2099 5E07              * the region being clipped to.
2100 5E07              *
2101 5E07              ****************************************************************
2102 5E07                       EXPORT iSeek1Region 
2103 5E07              iSeek1Region PROC 
2104 5E07              *              using RgnStateData
2105 5E07              *              using E0Vectors
2106 5E07
2107 5E07 A5 58 85 84           MoveLong StatePtrA,StatePtr    ; Seek along a
2108 5E0F 22 D8 1E E0           jsl   SeekRgn
2109 5E13 F0 07                 beq   AllDone
2110 5E15
2111 5E15              ;----------------------------------------------
2112 5E15              ;
2113 5E15              ; It changed so we have to rebuild
2114 5E15              ; the master scanmask buffer.
2115 5E15              ;
2116 5E15 20 1D 5E              jsr   JoinSetup
2117 5E18 22 DC 1E E0           jsl   Join1Buffer
2118 5E1C
2119 5E1C 6B           AllDone  rtl   
2120 5E1D
2121 5E1D                       ENDP 
2122 5E1D
2123 5E1D
2124 5E1D
2125 5E1D              ****************************************************************
2126 5E1D              *
2127 5E1D              * JoinSetUp
2128 5E1D              *
2129 5E1D              * This routine sets RFirstWord and RLastWord based on MinX,
2130 5E1D              * MaxX and LeftH
2131 5E1D              *
2132 5E1D              ****************************************************************
2133 5E1D                       EXPORT JoinSetup 
2134 5E1D              JoinSetup PROC 
2135 5E1D A5 90                 lda   MinX
2136 5E1F 38                    sec   
2137 5E20 E5 94                 sbc   LeftH
2138 5E22 4A                    lsr   a
2139 5E23 4A                    lsr   a
2140 5E24 4A                    lsr   a
2141 5E25 29 FE FF              and   #$FFFE
2142 5E28 85 9A                 sta   RFirstWord
2143 5E2A
2144 5E2A A5 92                 lda   MaxX                     ; Dec the max once
2145 5E2C 3A                    dec   a
2146 5E2D 38                    sec   
2147 5E2E E5 94                 sbc   LeftH
2148 5E30 4A                    lsr   a
2149 5E31 4A                    lsr   a
2150 5E32 4A                    lsr   a
2151 5E33 29 FE FF              and   #$FFFE
2152 5E36 85 9C                 sta   RLastWord
2153 5E38
2154 5E38 60                    rts   
2155 5E39
2156 5E39                       ENDP 
2157 5E39              ;                copy regions/init.seek
2158 5E39
2159 5E39
2160 5E39              ****************************************************************
2161 5E39              *
2162 5E39              * InitRgn
2163 5E39              *
2164 5E39              * The region to initialize is passed in RgnPtr.
2165 5E39              * The state record to setup is passed in StatePtr.
2166 5E39              * The pointer to the Scan Buffer to use is kept in ScanPtr.
2167 5E39              *
2168 5E39              ****************************************************************
2169 5E39                       EXPORT iInitRgn 
2170 5E39              iInitRgn PROC 
2171 5E39              *              using RgnStateData
2172 5E39
2173 5E39 A6 90                 ldx   MinX                     ; we do this for both types of
2174 5E3B A5 92                 lda   MaxX                     ; regions
2175 5E3D 20 8F 5F              jsr   LineSetup
2176 5E40 20 7B 5F              jsr   ZeroScanBuf
2177 5E43
2178 5E43 A7 80                 lda   [RgnPtr]                 ; now see if it is rect or bizzare
2179 5E45 C9 0A 00              cmp   #10
2180 5E48 F0 48                 beq   ItsRectangular
2181 5E4A
2182 5E4A E6 A4                 inc   NonRectRegions           ; set this flag for later use
2183 5E4C
2184 5E4C A9 00 00              lda   #$0000                   ; set this flag to 0
2185 5E4F 87 84                 sta   [StatePtr]
2186 5E51
2187 5E51              ;              lda #$0000	;already set to zero
2188 5E51 A0 1E 00              ldy   #S_SeekDir               ; Set for search down
2189 5E54 97 84                 sta   [StatePtr],y
2190 5E56
2191 5E56 A5 80                 lda   RgnPtr                   ; Set the RgnPtr in the StateRec
2192 5E58 A0 02 00              ldy   #S_RgnPtr
2193 5E5B 97 84                 sta   [StatePtr],y
2194 5E5D A5 82                 lda   RgnPtr+2
2195 5E5F A0 04 00              ldy   #S_RgnPtr+2
2196 5E62 97 84                 sta   [StatePtr],y
2197 5E64
2198 5E64 20 65 5F              jsr   InitDataPtr              ; set the dataptr in the state rec
2199 5E67
2200 5E67 20 CB 5E              jsr   SetBufStuff
2201 5E6A
2202 5E6A A9 01 C0              lda   #-MaxInt                 ; now put ThisV in state record
2203 5E6D A0 10 00              ldy   #S_ThisV
2204 5E70 97 84                 sta   [StatePtr],y
2205 5E72
2206 5E72 A0 02 00              ldy   #2                       ; NextV will be top of bounding
2207 5E75 B7 80                 lda   [RgnPtr],y               ; box
2208 5E77 A0 12 00              ldy   #S_NextV
2209 5E7A 97 84                 sta   [StatePtr],y
2210 5E7C
2211 5E7C A5 90                 lda   MinX                     ; MinX, MaxX & LeftH
2212 5E7E A0 14 00              ldy   #S_MinX
2213 5E81 97 84                 sta   [StatePtr],y
2214 5E83
2215 5E83 A5 92                 lda   MaxX
2216 5E85 A0 16 00              ldy   #S_MaxX
2217 5E88 97 84                 sta   [StatePtr],y
2218 5E8A
2219 5E8A A5 94                 lda   LeftH
2220 5E8C A0 18 00              ldy   #S_LeftH
2221 5E8F 97 84                 sta   [StatePtr],y
2222 5E91
2223 5E91 6B                    rtl   
2224 5E92
2225 5E92
2226 5E92              ItsRectangular                          ; 
2227 5E92
2228 5E92 A9 00 80              lda   #$8000                   ; set this flag to 1
2229 5E95 87 84                 sta   [StatePtr]
2230 5E97
2231 5E97 A5 9A                 lda   RFirstWord
2232 5E99 A0 02 00              ldy   #S_LOffset
2233 5E9C 97 84                 sta   [StatePtr],y
2234 5E9E
2235 5E9E A5 96                 lda   RLeftMask
2236 5EA0 A0 04 00              ldy   #S_LMask
2237 5EA3 97 84                 sta   [StatePtr],y
2238 5EA5
2239 5EA5 A5 9C                 lda   RLastWord
2240 5EA7 A0 06 00              ldy   #S_ROffset
2241 5EAA 97 84                 sta   [StatePtr],y
2242 5EAC
2243 5EAC A5 98                 lda   RRightMask
2244 5EAE A0 08 00              ldy   #S_RMask
2245 5EB1 97 84                 sta   [StatePtr],y
2246 5EB3
2247 5EB3 20 CB 5E              jsr   SetBufStuff
2248 5EB6
2249 5EB6 A0 02 00              ldy   #2                       ; Set S_RgnTop to top of bounding rect
2250 5EB9 B7 80                 lda   [RgnPtr],y
2251 5EBB A0 10 00              ldy   #S_RgnTop
2252 5EBE 97 84                 sta   [StatePtr],y
2253 5EC0
2254 5EC0 A0 06 00              ldy   #6                       ; set RgnBot to bot of bounding rect
2255 5EC3 B7 80                 lda   [RgnPtr],y
2256 5EC5 A0 12 00              ldy   #S_RgnBot
2257 5EC8 97 84                 sta   [StatePtr],y
2258 5ECA
2259 5ECA 6B                    rtl   
2260 5ECB
2261 5ECB              SetBufStuff                             ; 
2262 5ECB
2263 5ECB A5 88                 lda   ScanPtr                  ; now put the pointer to scan buf
2264 5ECD A0 0A 00              ldy   #S_ScanBuf               ; in state record
2265 5ED0 97 84                 sta   [StatePtr],y
2266 5ED2 A5 8A                 lda   ScanPtr+2
2267 5ED4 A0 0C 00              ldy   #S_ScanBuf+2
2268 5ED7 97 84                 sta   [StatePtr],y
2269 5ED9
2270 5ED9 A5 28                 lda   MaxWidth                 ; now put the buffer size in
2271 5EDB A0 0E 00              ldy   #S_ScanSize
2272 5EDE 97 84                 sta   [StatePtr],y
2273 5EE0
2274 5EE0 60                    rts   
2275 5EE1
2276 5EE1                       ENDP 
2277 5EE1
2278 5EE1              ****************************************************************
2279 5EE1              *
2280 5EE1              * InitRgnUp
2281 5EE1              *
2282 5EE1              * The region to initialize is passed in RgnPtr.
2283 5EE1              * The state record to setup is passed in StatePtr.
2284 5EE1              * The pointer to the Scan Buffer to use is kept in ScanPtr.
2285 5EE1              *
2286 5EE1              ****************************************************************
2287 5EE1                       EXPORT InitRgnUp 
2288 5EE1              InitRgnUp PROC 
2289 5EE1              *              using RgnStateData
2290 5EE1
2291 5EE1 A7 80                 lda   [RgnPtr]                 ; now see if it is rect or bizzare
2292 5EE3 C9 0A 00              cmp   #10
2293 5EE6 D0 03                 bne   NotRectang
2294 5EE8
2295 5EE8 4C 39 5E              jmp   iInitRgn                 ;handle in the normal way
2296 5EEB
2297 5EEB
2298 5EEB A6 90        NotRectang ldx   MinX                   ; we do this for both types of
2299 5EED A5 92                 lda   MaxX                     ; regions
2300 5EEF 20 8F 5F              jsr   LineSetup
2301 5EF2 20 7B 5F              jsr   ZeroScanBuf
2302 5EF5
2303 5EF5 E6 A4                 inc   NonRectRegions           ; set this flag for later use
2304 5EF7
2305 5EF7 A9 00 00              lda   #$0000                   ; set this flag to 0
2306 5EFA 87 84                 sta   [StatePtr]
2307 5EFC
2308 5EFC A9 FF FF              lda   #$FFFF                   ;
2309 5EFF A0 1E 00              ldy   #S_SeekDir               ; Set for search down
2310 5F02 97 84                 sta   [StatePtr],y
2311 5F04
2312 5F04 A5 80                 lda   RgnPtr                   ; Set the RgnPtr in the StateRec
2313 5F06 A0 02 00              ldy   #S_RgnPtr
2314 5F09 97 84                 sta   [StatePtr],y
2315 5F0B A5 82                 lda   RgnPtr+2
2316 5F0D A0 04 00              ldy   #S_RgnPtr+2
2317 5F10 97 84                 sta   [StatePtr],y
2318 5F12
2319 5F12 A5 80                 lda   RgnPtr                   ; set the dataptr in the state rec
2320 5F14 18                    clc   
2321 5F15 67 80                 adc   [RgnPtr]
2322 5F17 A0 06 00              ldy   #S_DataPtr
2323 5F1A 97 84                 sta   [StatePtr],y
2324 5F1C A5 82                 lda   RgnPtr+2
2325 5F1E 69 00 00              adc   #0
2326 5F21 A0 08 00              ldy   #S_DataPtr+2
2327 5F24 97 84                 sta   [StatePtr],y
2328 5F26
2329 5F26
2330 5F26 A5 88                 lda   ScanPtr                  ; now put the pointer to scan buf
2331 5F28 A0 0A 00              ldy   #S_ScanBuf               ; in state record
2332 5F2B 97 84                 sta   [StatePtr],y
2333 5F2D A5 8A                 lda   ScanPtr+2
2334 5F2F A0 0C 00              ldy   #S_ScanBuf+2
2335 5F32 97 84                 sta   [StatePtr],y
2336 5F34
2337 5F34 A5 28                 lda   MaxWidth                 ; now put the buffer size in
2338 5F36 A0 0E 00              ldy   #S_ScanSize
2339 5F39 97 84                 sta   [StatePtr],y
2340 5F3B
2341 5F3B
2342 5F3B A9 FF 3F              lda   #MaxInt                  ; Start at the Bottom
2343 5F3E A0 10 00              ldy   #S_ThisV
2344 5F41 97 84                 sta   [StatePtr],y
2345 5F43
2346 5F43
2347 5F43 A0 1A 00              ldy   #S_currVpos
2348 5F46 A7 80                 lda   [RgnPtr]
2349 5F48 3A                    dec   a
2350 5F49 3A                    dec   a
2351 5F4A 97 84                 sta   [StatePtr],y
2352 5F4C 20 3B 62              jsr   GetNextV
2353 5F4F
2354 5F4F
2355 5F4F
2356 5F4F A5 90                 lda   MinX                     ; MinX, MaxX & LeftH
2357 5F51 A0 14 00              ldy   #S_MinX
2358 5F54 97 84                 sta   [StatePtr],y
2359 5F56
2360 5F56 A5 92                 lda   MaxX
2361 5F58 A0 16 00              ldy   #S_MaxX
2362 5F5B 97 84                 sta   [StatePtr],y
2363 5F5D
2364 5F5D A5 94                 lda   LeftH
2365 5F5F A0 18 00              ldy   #S_LeftH
2366 5F62 97 84                 sta   [StatePtr],y
2367 5F64
2368 5F64 6B                    rtl   
2369 5F65
2370 5F65
2371 5F65
2372 5F65
2373 5F65                       ENDP 
2374 5F65
2375 5F65
2376 5F65
2377 5F65
2378 5F65
2379 5F65              ****************************************************************
2380 5F65              ****************************************************************
2381 5F65                       EXPORT InitDataPtr 
2382 5F65              InitDataPtr PROC 
2383 5F65              *              using RgnStateDATA
2384 5F65
2385 5F65 A5 80                 lda   RgnPtr                   ; Set the DataPtr in the State Rec
2386 5F67 18                    clc   
2387 5F68 69 0A 00              adc   #10
2388 5F6B A0 06 00              ldy   #s_DataPtr
2389 5F6E 97 84                 sta   [StatePtr],y
2390 5F70 A5 82                 lda   RgnPtr+2
2391 5F72 69 00 00              adc   #0
2392 5F75 A0 08 00              ldy   #S_DataPtr+2
2393 5F78 97 84                 sta   [StatePtr],y
2394 5F7A
2395 5F7A 60                    rts   
2396 5F7B
2397 5F7B                       ENDP 
2398 5F7B
2399 5F7B
2400 5F7B
2401 5F7B              ****************************************************************
2402 5F7B              *
2403 5F7B              * ZeroScanBuf
2404 5F7B              *
2405 5F7B              * This routine zeros a scan line buffer from RFirstWord - 2 to
2406 5F7B              * RLastWord (which were calculated by LineSetUp from MinX &
2407 5F7B              * MinY.
2408 5F7B              *
2409 5F7B              * I need to zero one word before in the case of painting
2410 5F7B              * pixels where the dest pointer was adjusted to be one word
2411 5F7B              * less that it really needs to be.
2412 5F7B              *
2413 5F7B              ****************************************************************
2414 5F7B                       EXPORT ZeroScanBuf 
2415 5F7B              ZeroScanBuf PROC 
2416 5F7B
2417 5F7B
2418 5F7B A4 9A                 ldy   RFirstWord
2419 5F7D F0 02                 beq   SkipBackup
2420 5F7F 88                    dey   
2421 5F80 88                    dey   
2422 5F81
2423 5F81 A9 00 00     SkipBackup lda   #0
2424 5F84 97 88        Loop     sta   [ScanPtr],y
2425 5F86 C8                    iny   
2426 5F87 C8                    iny   
2427 5F88 C4 9C                 cpy   RLastWord
2428 5F8A 90 F8                 bcc   Loop
2429 5F8C F0 F6                 beq   Loop
2430 5F8E
2431 5F8E 60                    rts   
2432 5F8F
2433 5F8F                       ENDP 
2434 5F8F
2435 5F8F
2436 5F8F              ****************************************************************
2437 5F8F              *
2438 5F8F              * LineSetup
2439 5F8F              *
2440 5F8F              * This is used by the Rectagular part of InitRgn and the
2441 5F8F              * non rectangular part of SeekRgn.  The Start and Stop Points
2442 5F8F              * are passed in A and X.   X is the start, A is the stop
2443 5F8F              *
2444 5F8F              ****************************************************************
2445 5F8F                       EXPORT LineSetup 
2446 5F8F              LineSetup PROC 
2447 5F8F              *              using RgnStateDATA
2448 5F8F
2449 5F8F 9B                    txy                            ; put this in y
2450 5F90
2451 5F90              ;	dec	a	; we dec the stop point as usual
2452 5F90              ;	sec		; Turn Local to scan coordinates
2453 5F90 18                    clc                            ; clear the carry to perform the dec a
2454 5F91
2455 5F91 E5 94                 sbc   LeftH
2456 5F93
2457 5F93 AA                    tax                            ; save this value in x
2458 5F94
2459 5F94 4A                    lsr   a                        ; make pixels into bytes by
2460 5F95 4A                    lsr   a                        ; dividing by 8
2461 5F96 4A                    lsr   a
2462 5F97 29 FE FF              and   #$FFFE                   ; make this even to mark word
2463 5F9A 85 9C                 sta   RLastWord                ; containing first pixel
2464 5F9C
2465 5F9C 8A                    txa                            ; get it back from x
2466 5F9D 29 0F 00              and   #15
2467 5FA0 0A                    asl   a
2468 5FA1 AA                    tax   
2469 5FA2 BF E2 5F FE           lda   >RightBitMask,x          ; Get appropriate mask
2470 5FA6 85 98                 sta   RRightMask
2471 5FA8
2472 5FA8 98                    tya                            ; change coordinates
2473 5FA9 38                    sec   
2474 5FAA E5 94                 sbc   LeftH
2475 5FAC
2476 5FAC AA                    tax                            ; save this value in x
2477 5FAD
2478 5FAD 4A                    lsr   a                        ; make pixels into bytes by 8
2479 5FAE 4A                    lsr   a
2480 5FAF 4A                    lsr   a
2481 5FB0 29 FE FF              and   #$FFFE
2482 5FB3 85 9A                 sta   RFirstWord
2483 5FB5
2484 5FB5 8A                    txa                            ; get it back from x
2485 5FB6 29 0F 00              and   #15
2486 5FB9 0A                    asl   a
2487 5FBA AA                    tax   
2488 5FBB BF C2 5F FE           lda   >LeftBitMask,x
2489 5FBF 85 96                 sta   RLeftMask
2490 5FC1
2491 5FC1 60                    rts   
2492 5FC2
2493 5FC2                       ENDP 
2494 5FC2
2495 5FC2
2496 5FC2              ****************************************************************
2497 5FC2              *
2498 5FC2              * Left Bit Mask Table
2499 5FC2              *
2500 5FC2              * Note that the "b" directive puts its inputs into mem as
2501 5FC2              * a byte stream s the byte on the left is at a lower memory
2502 5FC2              * loc than the byte on the right.
2503 5FC2              *
2504 5FC2              ****************************************************************
2505 5FC2                       EXPORT LeftBitMask 
2506 5FC2              LeftBitMask PROC 
2507 5FC2 FF FF                 DC B:%11111111,%11111111
2508 5FC4 7F FF                 DC B:%01111111,%11111111
2509 5FC6 3F FF                 DC B:%00111111,%11111111
2510 5FC8 1F FF                 DC B:%00011111,%11111111
2511 5FCA 0F FF                 DC B:%00001111,%11111111
2512 5FCC 07 FF                 DC B:%00000111,%11111111
2513 5FCE 03 FF                 DC B:%00000011,%11111111
2514 5FD0 01 FF                 DC B:%00000001,%11111111
2515 5FD2 00 FF                 DC B:%00000000,%11111111
2516 5FD4 00 7F                 DC B:%00000000,%01111111
2517 5FD6 00 3F                 DC B:%00000000,%00111111
2518 5FD8 00 1F                 DC B:%00000000,%00011111
2519 5FDA 00 0F                 DC B:%00000000,%00001111
2520 5FDC 00 07                 DC B:%00000000,%00000111
2521 5FDE 00 03                 DC B:%00000000,%00000011
2522 5FE0 00 01                 DC B:%00000000,%00000001
2523 5FE2
2524 5FE2                       ENDP 
2525 5FE2
2526 5FE2
2527 5FE2              ****************************************************************
2528 5FE2              *
2529 5FE2              * Right Bit Mask Table
2530 5FE2              *
2531 5FE2              * Note that the "b" directive puts its inputs into mem as
2532 5FE2              * a byte stream s the byte on the left is at a lower memory
2533 5FE2              * loc than the byte on the right.
2534 5FE2              *
2535 5FE2              ****************************************************************
2536 5FE2                       EXPORT RightBitMask 
2537 5FE2              RightBitMask PROC 
2538 5FE2 80 00                 DC B:%10000000,%00000000       ; 0
2539 5FE4 C0 00                 DC B:%11000000,%00000000       ; 1
2540 5FE6 E0 00                 DC B:%11100000,%00000000       ; 2
2541 5FE8 F0 00                 DC B:%11110000,%00000000       ; 3
2542 5FEA F8 00                 DC B:%11111000,%00000000       ; 4
2543 5FEC FC 00                 DC B:%11111100,%00000000       ; 5
2544 5FEE FE 00                 DC B:%11111110,%00000000       ; 6
2545 5FF0 FF 00                 DC B:%11111111,%00000000       ; 7
2546 5FF2 FF 80                 DC B:%11111111,%10000000       ; 8
2547 5FF4 FF C0                 DC B:%11111111,%11000000       ; 9
2548 5FF6 FF E0                 DC B:%11111111,%11100000       ; 10
2549 5FF8 FF F0                 DC B:%11111111,%11110000       ; 11
2550 5FFA FF F8                 DC B:%11111111,%11111000       ; 12
2551 5FFC FF FC                 DC B:%11111111,%11111100       ; 13
2552 5FFE FF FE                 DC B:%11111111,%11111110       ; 14
2553 6000 FF FF                 DC B:%11111111,%11111111       ; 15
2554 6002                       ENDP 
2555 6002
2556 6002
2557 6002
2558 6002
2559 6002              ****************************************************************
2560 6002              *
2561 6002              * SeekRgn
2562 6002              *
2563 6002              * The state record for the region to seek is passed in StatePtr
2564 6002              *
2565 6002              ****************************************************************
2566 6002                       EXPORT iSeekRgn 
2567 6002              iSeekRgn PROC 
2568 6002              *              using RgnStateDATA
2569 6002
2570 6002 A7 84                 lda   [StatePtr]
2571 6004 10 03                 bpl   NotRectangular
2572 6006 4C EA 60              jmp   ItsRectangular
2573 6009
2574 6009              ;----------------------------------------------
2575 6009              ;
2576 6009              ; Return very quickly if scanbuf is already
2577 6009              ; current.
2578 6009              ;
2579 6009              NotRectangular                          ; 
2580 6009 A0 1E 00              ldy   #S_SeekDir
2581 600C B7 84                 lda   [StatePtr],y
2582 600E F0 03                 beq   GoingDown
2583 6010 4C 24 61              jmp   GoingUP
2584 6013
2585 6013 A5 40        GoingDown lda   CurrentY                ; if the current y is less than
2586 6015 A0 10 00              ldy   #S_ThisV                 ; ThisV then we have to reseek
2587 6018 D7 84                 cmp   [StatePtr],y             ; from top of region
2588 601A 30 0A                 bmi   Restart
2589 601C
2590 601C A0 12 00              ldy   #S_NextV                 ; if the current y is less than
2591 601F D7 84                 cmp   [StatePtr],y             ; NextV then the scan buf does
2592 6021 10 3D                 bpl   ItMustChange
2593 6023 4C 21 61              jmp   AllDone_NC               ; not change!
2594 6026
2595 6026              Restart                                 ; 
2596 6026 A0 02 00              ldy   #s_RgnPtr                ; get the pointer to the region
2597 6029 B7 84                 lda   [StatePtr],y             ; add 10 and put result in the
2598 602B 18                    clc                            ; data pointer.
2599 602C 69 0A 00              adc   #10
2600 602F AA                    tax   
2601 6030 A0 04 00              ldy   #s_RgnPtr+2
2602 6033 B7 84                 lda   [StatePtr],y
2603 6035
2604 6035 69 00 00              adc   #0
2605 6038 A0 08 00              ldy   #s_DataPtr+2
2606 603B 97 84                 sta   [StatePtr],y
2607 603D
2608 603D A0 06 00              ldy   #s_DataPtr
2609 6040 8A                    txa   
2610 6041 97 84                 sta   [StatePtr],y
2611 6043
2612 6043 20 E7 61              jsr   GetStateInfo             ; bring things down to zp
2613 6046
2614 6046 A6 90                 ldx   MinX                     ; set up to clear the scan buff
2615 6048 A5 92                 lda   MaxX                     ;
2616 604A 20 8F 5F              jsr   LineSetup
2617 604D
2618 604D A0 0A 00              ldy   #S_ScanBuf
2619 6050 B7 84                 lda   [StatePtr],y
2620 6052 85 88                 sta   ScanPtr
2621 6054 A0 0C 00              ldy   #S_ScanBuf+2
2622 6057 B7 84                 lda   [StatePtr],y
2623 6059 85 8A                 sta   ScanPtr+2
2624 605B
2625 605B 20 7B 5F              jsr   ZeroScanBuf
2626 605E 80 03                 bra   JoinRest
2627 6060
2628 6060
2629 6060              ;----------------------------------------------
2630 6060              ;
2631 6060              ; Gosh, now I need to do something here.
2632 6060              ; I'll start by getting info I'll need from
2633 6060              ; the state record.
2634 6060              ;
2635 6060 20 E7 61     ItMustChange jsr   GetStateInfo
2636 6063
2637 6063              JoinRest                                ; 
2638 6063
2639 6063
2640 6063 A7 8C        Down1    lda   [DataPtr]
2641 6065 A0 10 00              ldy   #S_ThisV                 ; update ThisV
2642 6068 97 84                 sta   [StatePtr],y
2643 606A
2644 606A A5 8C A6 8E           BumpLongBy2 DataPtr            ; bump the data ptr twice
2645 607A
2646 607A
2647 607A A7 8C        NextHor  lda   [DataPtr]                ; get left coord
2648 607C C9 FF 3F              cmp   #MaxInt
2649 607F F0 39                 beq   EndOfLine
2650 6081
2651 6081 AA                    tax                            ; put left in x
2652 6082
2653 6082 E6 8C D0 02           IncLong DataPtr 
2654 6088 E6 8C D0 02           IncLong DataPtr 
2655 608E
2656 608E A7 8C                 lda   [DataPtr]                ; get right in a
2657 6090
2658 6090 E6 8C D0 02           IncLong DataPtr 
2659 6096 E6 8C D0 02           IncLong DataPtr 
2660 609C
2661 609C C5 90                 cmp   MinX                     ; if Right <= MinX then nexthor
2662 609E 30 DA                 bmi   NextHor
2663 60A0 F0 D8                 beq   NextHor
2664 60A2
2665 60A2 E4 92                 cpx   MaxX                     ; if Left > MaxX then NextHor
2666 60A4 10 D4                 bpl   NextHor
2667 60A6
2668 60A6 E4 90                 cpx   MinX                     ; if Left > MinX then LeftOK
2669 60A8 10 02                 bpl   LeftOK
2670 60AA
2671 60AA A6 90                 ldx   MinX
2672 60AC C5 92        LeftOk   cmp   MaxX                     ; if Right < MaxX then RightOK
2673 60AE 30 02                 bmi   RightOK
2674 60B0 A5 92                 lda   MaxX
2675 60B2
2676 60B2 20 8F 5F     RightOK  jsr   LineSetUp
2677 60B5 20 27 62              jsr   InvertBuf
2678 60B8 80 C0                 bra   NextHor
2679 60BA
2680 60BA              EndOfLine                               ; 
2681 60BA A5 8C A6 8E           BumpLongBy2 DataPtr            ; bump data ptr so points to the next v
2682 60CA A7 8C                 lda   [DataPtr]                ; update nextV in State rec
2683 60CC A0 12 00              ldy   #s_NextV
2684 60CF 97 84                 sta   [StatePtr],y
2685 60D1
2686 60D1 C5 40                 cmp   CurrentY                 ; if NextV < CurrentY
2687 60D3 F0 02                 beq   DownAgain
2688 60D5 10 03                 bpl   DoneNow
2689 60D7
2690 60D7 4C 63 60     DownAgain jmp   Down1
2691 60DA
2692 60DA
2693 60DA              DoneNow                                 ; 
2694 60DA              ;----------------------------------------------
2695 60DA              ;
2696 60DA              ; It's all done so update the data ptr in
2697 60DA              ; the state record
2698 60DA              ;
2699 60DA A0 06 00              ldy   #S_DataPtr
2700 60DD A5 8C                 lda   DataPtr
2701 60DF 97 84                 sta   [StatePtr],y
2702 60E1 A0 08 00              ldy   #S_DataPtr+2
2703 60E4 A5 8E                 lda   DataPtr+2
2704 60E6 97 84                 sta   [StatePtr],y
2705 60E8
2706 60E8
2707 60E8 80 34                 bra   AllDone_C
2708 60EA
2709 60EA              ItsRectangular                          ; 
2710 60EA A5 40                 lda   CurrentY
2711 60EC A0 10 00              ldy   #S_RgnTop
2712 60EF D7 84                 cmp   [StatePtr],y
2713 60F1 30 1A                 bmi   Outside
2714 60F3
2715 60F3 A0 12 00              ldy   #S_RgnBot
2716 60F6 D7 84                 cmp   [StatePtr],y
2717 60F8 10 13                 bpl   Outside
2718 60FA
2719 60FA A7 84                 lda   [StatePtr]               ; this flag indicate if scan buf
2720 60FC 29 01 00              and   #1                       ; is already set
2721 60FF D0 20                 bne   AllDone_NC
2722 6101
2723 6101 20 0B 62              jsr   RectScanInvert
2724 6104
2725 6104 A7 84                 lda   [StatePtr]
2726 6106 09 01 00              ora   #1
2727 6109 87 84                 sta   [StatePtr]
2728 610B 80 11                 bra   AllDone_C
2729 610D
2730 610D A7 84        OutSide  lda   [StatePtr]
2731 610F 29 01 00              and   #1
2732 6112 F0 0D                 beq   AllDone_NC
2733 6114
2734 6114 20 0B 62              jsr   RectScanInvert
2735 6117
2736 6117 A7 84                 lda   [StatePtr]
2737 6119 29 FE FF              and   #$FFFE
2738 611C 87 84                 sta   [StatePtr]
2739 611E
2740 611E C2 02        AllDone_C rep   #%00000010              ; clear the z flag
2741 6120 6B                    rtl   
2742 6121
2743 6121 E2 02        AllDone_NC sep   #%00000010             ; set the z flag
2744 6123 6B                    rtl   
2745 6124
2746 6124
2747 6124
2748 6124              GoingUp                                 ; 
2749 6124
2750 6124 A5 40                 lda   CurrentY                 ; if the current y is less than
2751 6126 1A                    inc   a
2752 6127 A0 10 00              ldy   #S_ThisV                 ; ThisV then we have to reseek
2753 612A D7 84                 cmp   [StatePtr],y             ; from top of region
2754 612C 10 0E                 bpl   RestU
2755 612E F0 0C                 beq   RestU
2756 6130
2757 6130 A0 12 00              ldy   #S_NextV                 ; if the current y is less than
2758 6133 D7 84                 cmp   [StatePtr],y             ; NextV then the scan buf does
2759 6135
2760 6135 F0 34                 beq   UpItMustChng
2761 6137 30 32                 bmi   UpItMustChng
2762 6139
2763 6139 4C 21 61              jmp   AllDone_NC               ; not change!
2764 613C
2765 613C              RestU                                   ; 
2766 613C              ;              _sysbeep
2767 613C A0 14 00              ldy   #S_MinX
2768 613F B7 84                 lda   [StatePtr],y
2769 6141 85 90                 sta   MinX
2770 6143
2771 6143 A0 16 00              ldy   #S_MaxX
2772 6146 B7 84                 lda   [StatePtr],y
2773 6148 85 92                 sta   MaxX
2774 614A
2775 614A A0 18 00              ldy   #S_LeftH
2776 614D B7 84                 lda   [StatePtr],y
2777 614F 85 94                 sta   LeftH
2778 6151
2779 6151 A6 90                 ldx   MinX                     ; set up to clear the scan buff
2780 6153 A5 92                 lda   MaxX                     ;
2781 6155 20 8F 5F              jsr   LineSetup
2782 6158
2783 6158 A0 0A 00              ldy   #S_ScanBuf
2784 615B B7 84                 lda   [StatePtr],y
2785 615D 85 88                 sta   ScanPtr
2786 615F A0 0C 00              ldy   #S_ScanBuf+2
2787 6162 B7 84                 lda   [StatePtr],y
2788 6164 85 8A                 sta   ScanPtr+2
2789 6166
2790 6166 20 7B 5F              jsr   ZeroScanBuf
2791 6169 80 15                 bra   JoinRestU
2792 616B
2793 616B
2794 616B              ;----------------------------------------------
2795 616B              ;
2796 616B              ; Gosh, now I need to do something here.
2797 616B              ; I'll start by getting info I'll need from
2798 616B              ; the state record.
2799 616B              ;
2800 616B              UpItMustChng                            ; 
2801 616B A0 14 00              ldy   #S_MinX
2802 616E B7 84                 lda   [StatePtr],y
2803 6170 85 90                 sta   MinX
2804 6172
2805 6172 A0 16 00              ldy   #S_MaxX
2806 6175 B7 84                 lda   [StatePtr],y
2807 6177 85 92                 sta   MaxX
2808 6179
2809 6179 A0 18 00              ldy   #S_LeftH
2810 617C B7 84                 lda   [StatePtr],y
2811 617E 85 94                 sta   LeftH
2812 6180
2813 6180
2814 6180              JoinRestU                               ; 
2815 6180              UP1                                     ; 
2816 6180
2817 6180 A0 1A 00              ldy   #S_currVpos
2818 6183 B7 84                 lda   [StatePtr],y             ;get index into region
2819 6185 48                    pha                            ;save for later
2820 6186 A8                    tay   
2821 6187 B7 80                 lda   [RgnPtr],y               ;get current line number
2822 6189
2823 6189 A0 10 00              ldy   #S_ThisV                 ; update ThisV
2824 618C 97 84                 sta   [StatePtr],y
2825 618E
2826 618E 7A                    ply                            ;recover
2827 618F C8                    iny                            ;index to first x
2828 6190 C8                    iny   
2829 6191
2830 6191 B7 80        NextHorU lda   [RgnPtr],y               ; get left coord
2831 6193 C9 FF 3F              cmp   #MaxInt
2832 6196 F0 27                 beq   EndOfLineU
2833 6198
2834 6198 AA                    tax                            ; put left in x
2835 6199
2836 6199 C8                    iny   
2837 619A C8                    iny                            ;index to next x
2838 619B
2839 619B B7 80                 lda   [RgnPtr],y               ; get right in a
2840 619D
2841 619D C8                    iny   
2842 619E C8                    iny   
2843 619F
2844 619F C5 90                 cmp   MinX                     ; if Right <= MinX then nexthor
2845 61A1 30 EE                 bmi   NextHorU
2846 61A3 F0 EC                 beq   NextHorU
2847 61A5
2848 61A5 E4 92                 cpx   MaxX                     ; if Left > MaxX then NextHor
2849 61A7 10 E8                 bpl   NextHorU
2850 61A9
2851 61A9 E4 90                 cpx   MinX                     ; if Left > MinX then LeftOK
2852 61AB 10 02                 bpl   LeftOKU
2853 61AD
2854 61AD A6 90                 ldx   MinX
2855 61AF C5 92        LeftOkU  cmp   MaxX                     ; if Right < MaxX then RightOK
2856 61B1 30 02                 bmi   RightOKU
2857 61B3 A5 92                 lda   MaxX
2858 61B5
2859 61B5 5A           RightOKU phy   
2860 61B6 20 8F 5F              jsr   LineSetUp
2861 61B9 20 27 62              jsr   InvertBuf
2862 61BC 7A                    ply   
2863 61BD 80 D2                 bra   NextHorU
2864 61BF
2865 61BF              EndOfLineU                              ; 
2866 61BF A0 1A 00              ldy   #S_currVpos
2867 61C2 B7 84                 lda   [StatePtr],y
2868 61C4 A8                    tay   
2869 61C5 B7 80                 lda   [RgnPtr],y
2870 61C7 A0 10 00              ldy   #S_ThisV
2871 61CA 97 84                 sta   [StatePtr],y
2872 61CC 20 3B 62              jsr   GetNextV                 ;Gets the next v
2873 61CF A0 1A 00              ldy   #S_currVpos
2874 61D2 B7 84                 lda   [StatePtr],y             ; index to next line number
2875 61D4 A8                    tay   
2876 61D5 B7 80                 lda   [RgnPtr],y
2877 61D7 A0 12 00              ldy   #s_NextV
2878 61DA 97 84                 sta   [StatePtr],y
2879 61DC 3A                    dec   a
2880 61DD C5 40                 cmp   CurrentY                 ; if NextV < CurrentY
2881 61DF 30 03                 bmi   DoneNowU
2882 61E1
2883 61E1 4C 80 61     UPAgain  jmp   UP1
2884 61E4 4C DA 60     DoneNowU jmp   DoneNow
2885 61E7
2886 61E7                       ENDP 
2887 61E7
2888 61E7
2889 61E7              ****************************************************************
2890 61E7              *
2891 61E7              * GetStateInfo
2892 61E7              *
2893 61E7              * This is a routine shared by alternative paths through
2894 61E7              * SeekRgn.  It pulls necessary info out of the state record
2895 61E7              * and puts them on zero page.
2896 61E7              *
2897 61E7              ****************************************************************
2898 61E7                       EXPORT GetStateInfo 
2899 61E7              GetStateInfo PROC 
2900 61E7              *              using RgnStateDATA
2901 61E7
2902 61E7 A0 14 00              ldy   #S_MinX
2903 61EA B7 84                 lda   [StatePtr],y
2904 61EC 85 90                 sta   MinX
2905 61EE
2906 61EE A0 16 00              ldy   #S_MaxX
2907 61F1 B7 84                 lda   [StatePtr],y
2908 61F3 85 92                 sta   MaxX
2909 61F5
2910 61F5 A0 18 00              ldy   #S_LeftH
2911 61F8 B7 84                 lda   [StatePtr],y
2912 61FA 85 94                 sta   LeftH
2913 61FC
2914 61FC A0 06 00              ldy   #S_DataPtr
2915 61FF B7 84                 lda   [StatePtr],y
2916 6201 85 8C                 sta   DataPtr
2917 6203
2918 6203 A0 08 00              ldy   #S_DataPtr+2
2919 6206 B7 84                 lda   [StatePtr],y
2920 6208 85 8E                 sta   DataPtr+2
2921 620A
2922 620A 60                    rts   
2923 620B
2924 620B                       ENDP 
2925 620B
2926 620B
2927 620B
2928 620B
2929 620B              ****************************************************************
2930 620B              *
2931 620B              * RectScanInvert
2932 620B              *
2933 620B              * This is a fast inverter for the scan line buff optimizing
2934 620B              * for rectangular region.
2935 620B              *
2936 620B              ****************************************************************
2937 620B                       EXPORT RectScanInvert 
2938 620B              RectScanInvert PROC 
2939 620B              *              using RgnStateDATA
2940 620B
2941 620B A0 02 00              ldy   #S_LOffset
2942 620E B7 84                 lda   [StatePtr],y
2943 6210 85 9A                 sta   RFirstWord
2944 6212
2945 6212 A0 04 00              ldy   #S_LMask
2946 6215 B7 84                 lda   [StatePtr],y             ; get left mask
2947 6217 85 96                 sta   RLeftMask
2948 6219
2949 6219 A0 06 00              ldy   #S_ROffset
2950 621C B7 84                 lda   [StatePtr],y             ; get right offset
2951 621E 85 9C                 sta   RLastWord
2952 6220
2953 6220 A0 08 00              ldy   #S_RMask
2954 6223 B7 84                 lda   [StatePtr],y             ; get right mask
2955 6225 85 98                 sta   RRightMask
2956 6227
2957 6227
2958 6227                       EXPORT InvertBuf 
2959 6227              InvertBuf                               ; 
2960 6227 8B                    phb                            ; save the data bank reg
2961 6228 A0 0A 00              ldy   #S_ScanBuf
2962 622B B7 84                 lda   [StatePtr],y
2963 622D 85 88                 sta   ScanPtr
2964 622F 8B                    phb                            ; dummy byte on stack
2965 6230 C8                    iny   
2966 6231 B7 84                 lda   [StatePtr],y             ; get high byte of 3 byte ptr
2967 6233 83 00                 sta   0,s                      ; overstore dummy
2968 6235 AB                    plb                            ; set b
2969 6236
2970 6236 20 62 62              jsr   SpecialSlab
2971 6239
2972 6239 AB                    plb                            ; restore data bank reg
2973 623A
2974 623A 60                    rts   
2975 623B
2976 623B                       ENDP 
2977 623B
2978 623B
2979 623B
2980 623B
2981 623B              *****************************************************************
2982 623B              *
2983 623B              *  GetNextV
2984 623B              *      This routine searches from the present Yn. An Index into
2985 623B              *      the region description (currVpos) is used to keep track
2986 623B              *      of the position of the active line of the region.
2987 623B              *
2988 623B              *
2989 623B              *
2990 623B              *  Inputs: none
2991 623B              *
2992 623B              *  Outputs: none
2993 623B              *
2994 623B              *  Side effects: Sets currVpos in region state record to the index for the
2995 623B              *          next line.
2996 623B              *
2997 623B              *****************************************************************
2998 623B                       EXPORT GetNextV 
2999 623B              GetNextV PROC 
3000 623B              *          using RgnStateData
3001 623B
3002 623B A0 1A 00              ldy   #S_currVpos              ;Get index to the current Yn
3003 623E B7 84                 lda   [StatePtr],y
3004 6240 A8                    tay   
3005 6241
3006 6241 88                    dey                            ;Start by bumping the index to point to
3007 6242 88                    dey                            ;the end of the previous line.
3008 6243
3009 6243
3010 6243 C0 0A 00     sloop    cpy   #10                      ;are we already into the rect desc?
3011 6246 30 09                 bmi   done
3012 6248
3013 6248 88                    dey                            ;point to Xn
3014 6249 88                    dey   
3015 624A
3016 624A B7 80                 lda   [RgnPtr],y
3017 624C C9 FF 3F              cmp   #Maxint                  ;is it the end of the next line?
3018 624F D0 F2                 bne   sloop                    ;nope, gotta go up one one more.
3019 6251
3020 6251 C8           done     iny                            ;point to Yn
3021 6252 C8                    iny   
3022 6253 B7 80                 lda   [RgnPtr],y               ;get line number
3023 6255 BB                    tyx                            ;save index
3024 6256 A0 12 00              ldy   #S_NextV
3025 6259 97 84                 sta   [StatePtr],y             ;save next line
3026 625B
3027 625B 8A                    txa                            ;recover index
3028 625C A0 1A 00              ldy   #S_currVpos
3029 625F 97 84                 sta   [StatePtr],y
3030 6261              ;          ldy     #S_DataIndex
3031 6261              ;          sta     [StatePtr],y
3032 6261 60                    rts   
3033 6262                       ENDP 
3034 6262              ;                copy regions/special.slab
3035 6262              ****************************************************************
3036 6262              *
3037 6262              * SpecialSlab
3038 6262              *
3039 6262              * All the slab routines use the same data on zero page. This
3040 6262              * one is no different.
3041 6262              *
3042 6262              * Before any slab routine is called, the data bank register
3043 6262              * is set to the bank containing the pixel map.
3044 6262              *
3045 6262              * The following are set up on zero page before this routine
3046 6262              * is called:
3047 6262              *
3048 6262              * Inputs:
3049 6262              *
3050 6262              *    RLeftMask      The Pixels not being touched on the left are
3051 6262              *                  set to zero in this word mask.
3052 6262              *
3053 6262              *    RRightMask     The Pixels not being touched on the right are
3054 6262              *                  set to zero in this word mask
3055 6262              *
3056 6262              *    RFirstWord     The First word on the scan line to deal with
3057 6262              *
3058 6262              *    RLastWord      The last word on the scan line to deal with
3059 6262              *
3060 6262              *    ScanPtr       Points to the start of the current scan line
3061 6262              *                  (or scan line equiv since can draw into mem).
3062 6262              *
3063 6262              *
3064 6262              *
3065 6262              * Variables
3066 6262              *
3067 6262              *    None
3068 6262              *
3069 6262              * 2/1/89            Mensch
3070 6262              *                   Optimized to use a table offset aproach to this action
3071 6262              *
3072 6262              * 3/1/89            Mensch
3073 6262              * Removed optimizations, this routine is not called often enough to warrant
3074 6262              * an additional 1024 bytes in ROM and patch file.
3075 6262              *
3076 6262              ****************************************************************
3077 6262                       EXPORT SpecialSlab 
3078 6262              SpecialSlab PROC 
3079 6262              MaxInRow equ   80
3080 6262              *              using CoreData
3081 6262
3082 6262 A5 96                 lda   RLeftMask
3083 6264
3084 6264 A4 9A                 ldy   RFirstWord
3085 6266 C4 9C                 cpy   RLastWord
3086 6268 90 02                 bcc   MultiWords
3087 626A
3088 626A 25 98                 and   RRightMask               ; one word only--combine masks
3089 626C              MultiWords                              ; 
3090 626C
3091 626C 51 88                 eor   (ScanPtr),y
3092 626E 91 88                 sta   (ScanPtr),y
3093 6270
3094 6270 80 07                 bra   IncCntrs
3095 6272
3096 6272
3097 6272 A9 FF FF     NextWord lda   #$FFFF
3098 6275 51 88                 eor   (ScanPtr),y
3099 6277 91 88                 sta   (ScanPtr),y              ; put it in dest
3100 6279
3101 6279 C8           IncCntrs iny   
3102 627A C8                    iny   
3103 627B
3104 627B C4 9C                 cpy   RLastWord
3105 627D 90 F3                 bcc   NextWord
3106 627F D0 06                 bne   AllDone                  ; was only one word
3107 6281
3108 6281
3109 6281 A5 98                 lda   RRightMask
3110 6283 51 88                 eor   (ScanPtr),y
3111 6285 91 88                 sta   (ScanPtr),y
3112 6287
3113 6287
3114 6287 60           AllDone  rts   
3115 6288
3116 6288                       ENDP 
3117 6288
3118 6288              ****************************************************************
3119 6288
3120 6288              ;                copy regions/join.buffers
3121 6288              ****************************************************************
3122 6288              *
3123 6288              * Join3Buffers
3124 6288              *
3125 6288              * This takes the three 1-bit per pixel scan line buffers,
3126 6288              * ANDs them together and expands them to n-bits per pixel
3127 6288              * based on the PortSCB.
3128 6288              *
3129 6288              * This routine assumes that the four buffers are all in the 
3130 6288              * same bank!
3131 6288              *
3132 6288              ****************************************************************
3133 6288                       EXPORT iJoin3Buffers 
3134 6288              iJoin3Buffers PROC 
3135 6288
3136 6288 24 0B                 bit   PortSCB-1
3137 628A 10 17                 bpl   Mode320
3138 628C
3139 628C
3140 628C A4 9A                 ldy   RFirstWord               ; backup up twice unless it is
3141 628E F0 02                 beq   Loop640                  ; zero
3142 6290 88                    dey   
3143 6291 88                    dey   
3144 6292
3145 6292 B7 5C        Loop640  lda   [ScanPtrA],y             ; merge the three
3146 6294 37 6C                 and   [ScanPtrB],y
3147 6296 37 7C                 and   [ScanPtrC],y
3148 6298
3149 6298 20 0F 63              jsr   Expand640
3150 629B
3151 629B C4 9C                 cpy   RLastWord
3152 629D 90 F3                 bcc   Loop640                  ; continue until greater than
3153 629F F0 F1                 beq   Loop640
3154 62A1
3155 62A1 80 15                 bra   AllDone
3156 62A3
3157 62A3
3158 62A3              Mode320                                 ; 
3159 62A3 A4 9A                 ldy   RFirstWord               ; backup 2 unless zero
3160 62A5 F0 02                 beq   Loop320
3161 62A7 88                    dey   
3162 62A8 88                    dey   
3163 62A9
3164 62A9 B7 5C        Loop320  lda   [ScanPtrA],y             ; merge the three
3165 62AB 37 6C                 and   [ScanPtrB],y
3166 62AD 37 7C                 and   [ScanPtrC],y
3167 62AF
3168 62AF 20 34 63              jsr   Expand320
3169 62B2
3170 62B2 C4 9C                 cpy   RLastWord
3171 62B4 90 F3                 bcc   Loop320                  ; continue until greater than
3172 62B6 F0 F1                 beq   Loop320
3173 62B8
3174 62B8              AllDone                                 ; 
3175 62B8 6B                    rtl   
3176 62B9
3177 62B9                       ENDP 
3178 62B9
3179 62B9              ****************************************************************
3180 62B9              *
3181 62B9              * Join2Buffers
3182 62B9              *
3183 62B9              * This takes two 1-bit per pixel scan line buffers,
3184 62B9              * ANDs them together and expands them to n-bits per pixel
3185 62B9              * based on the PortSCB.
3186 62B9              *
3187 62B9              * This routine assumes that the four buffers are all in the 
3188 62B9              * same bank!
3189 62B9              *
3190 62B9              ****************************************************************
3191 62B9                       EXPORT iJoin2Buffers 
3192 62B9              iJoin2Buffers PROC 
3193 62B9
3194 62B9 24 0B                 bit   PortSCB-1
3195 62BB 10 15                 bpl   Mode320
3196 62BD
3197 62BD
3198 62BD A4 9A                 ldy   RFirstWord               ; backup 2 unless zero
3199 62BF F0 02                 beq   Loop640
3200 62C1 88                    dey   
3201 62C2 88                    dey   
3202 62C3 B7 5C        Loop640  lda   [ScanPtrA],y             ; merge the two
3203 62C5 37 6C                 and   [ScanPtrB],y
3204 62C7
3205 62C7 20 0F 63              jsr   Expand640
3206 62CA
3207 62CA C4 9C                 cpy   RLastWord
3208 62CC 90 F5                 bcc   Loop640                  ; continue until greater than
3209 62CE F0 F3                 beq   Loop640
3210 62D0
3211 62D0 80 13                 bra   AllDone
3212 62D2
3213 62D2
3214 62D2              Mode320                                 ; 
3215 62D2 A4 9A                 ldy   RFirstWord               ; backup 2 unless zero
3216 62D4 F0 02                 beq   loop320
3217 62D6 88                    dey   
3218 62D7 88                    dey   
3219 62D8 B7 5C        Loop320  lda   [ScanPtrA],y             ; merge the two
3220 62DA 37 6C                 and   [ScanPtrB],y
3221 62DC
3222 62DC 20 34 63              jsr   Expand320
3223 62DF
3224 62DF C4 9C                 cpy   RLastWord
3225 62E1 90 F5                 bcc   Loop320                  ; continue until greater than
3226 62E3 F0 F3                 beq   Loop320
3227 62E5
3228 62E5              AllDone                                 ; 
3229 62E5 6B                    rtl   
3230 62E6
3231 62E6                       ENDP 
3232 62E6
3233 62E6              ****************************************************************
3234 62E6              *
3235 62E6              * Join1Buffers
3236 62E6              *
3237 62E6              * This takes one 1-bit per pixel scan line buffer,
3238 62E6              * and expands it to n-bits per pixel based on the PortSCB.
3239 62E6              *
3240 62E6              * This routine assumes that the four buffers are all in the 
3241 62E6              * same bank!
3242 62E6              *
3243 62E6              ****************************************************************
3244 62E6
3245 62E6                       EXPORT iJoin1Buffer 
3246 62E6              iJoin1Buffer PROC 
3247 62E6
3248 62E6 24 0B                 bit   PortSCB-1
3249 62E8 10 13                 bpl   Mode320
3250 62EA
3251 62EA
3252 62EA A4 9A                 ldy   RFirstWord               ; backup 2 unless zero
3253 62EC F0 02                 beq   loop640
3254 62EE 88                    dey   
3255 62EF 88                    dey   
3256 62F0 B7 5C        Loop640  lda   [ScanPtrA],y             ; expand the one
3257 62F2
3258 62F2 20 0F 63              jsr   Expand640
3259 62F5
3260 62F5 C4 9C                 cpy   RLastWord
3261 62F7 90 F7                 bcc   Loop640                  ; continue until greater than
3262 62F9 F0 F5                 beq   Loop640
3263 62FB
3264 62FB 80 11                 bra   AllDone
3265 62FD
3266 62FD
3267 62FD              Mode320                                 ; 
3268 62FD A4 9A                 ldy   RFirstWord               ; backup 2 unless zero
3269 62FF F0 02                 beq   loop320
3270 6301 88                    dey   
3271 6302 88                    dey   
3272 6303 B7 5C        Loop320  lda   [ScanPtrA],y             ; expand the one
3273 6305
3274 6305 20 34 63              jsr   Expand320
3275 6308
3276 6308 C4 9C                 cpy   RLastWord
3277 630A 90 F7                 bcc   Loop320                  ; continue until greater than
3278 630C F0 F5                 beq   Loop320
3279 630E
3280 630E              AllDone                                 ; 
3281 630E 6B                    rtl   
3282 630F
3283 630F                       ENDP 
3284 630F
3285 630F
3286 630F
3287 630F
3288 630F              ****************************************************************
3289 630F              *
3290 630F              * Expand640
3291 630F              *
3292 630F              * This expands the word in a from 16 1-bit pixels to two
3293 630F              * words of 16 2-bit pixels and puts them in the ScanMaskRef
3294 630F              * starting at a value represented by Y
3295 630F              *
3296 630F              ****************************************************************
3297 630F                       EXPORT Expand640 
3298 630F              Expand640 PROC 
3299 630F
3300 630F 48                    pha                            ; save on stack
3301 6310 29 FF 00              and   #$00FF                   ; deal only with one byte at at time
3302 6313 0A                    asl   a                        ; double value so can index into
3303 6314 AA                    tax                            ; conversion table
3304 6315 BF 72 67 FE           lda   >ConTable640,x
3305 6319 AA                    tax                            ; save this in x
3306 631A 98                    tya                            ; get y in a so can double it
3307 631B 0A                    asl   a                        ; and it becomes index into chunky
3308 631C A8                    tay                            ; buffer.
3309 631D 8A                    txa                            ; get what to store back from x
3310 631E 97 4C                 sta   [ScanMaskRef],y          ; store it
3311 6320 68                    pla                            ; now get original merged word off stack
3312 6321 EB                    xba                            ; get the high byte in low
3313 6322 29 FF 00              and   #$00FF                   ; and now we'll work with it
3314 6325 0A                    asl   a                        ; double so it is index into con table
3315 6326 AA                    tax   
3316 6327 BF 72 67 FE           lda   >ConTable640,x
3317 632B C8                    iny                            ; bump y so it points to new word in
3318 632C C8                    iny                            ; chunky buffer
3319 632D 97 4C                 sta   [ScanMaskRef],y          ; store it
3320 632F 98                    tya                            ; halve index so can point to small
3321 6330 4A                    lsr   a                        ; buffer again.
3322 6331 A8                    tay   
3323 6332 C8                    iny                            ; bump once (already bumped second time
3324 6333 60                    rts   
3325 6334
3326 6334                       ENDP 
3327 6334
3328 6334              ****************************************************************
3329 6334              *
3330 6334              * Expand620
3331 6334              *
3332 6334              * This expands the word in a from 16 1-bit pixels to four
3333 6334              * words of 16 4-bit pixels and puts them in the ScanMaskRef
3334 6334              * starting at a value represented by Y
3335 6334              *
3336 6334              ****************************************************************
3337 6334                       EXPORT Expand320 
3338 6334              Expand320 PROC 
3339 6334
3340 6334 48                    pha                            ; save on stack
3341 6335 29 FF 00              and   #$00FF                   ; deal only with one byte at at time
3342 6338 0A                    asl   a                        ; quadruple value so can index into
3343 6339 0A                    asl   a                        ; convertion table
3344 633A AA                    tax   
3345 633B BF 74 63 FE           lda   >ConTable320+2,x
3346 633F 48                    pha   
3347 6340 BF 72 63 FE           lda   >ConTable320,x
3348 6344 AA                    tax                            ; save this in x
3349 6345 98                    tya                            ; get y in a so can mult by 4
3350 6346 0A                    asl   a                        ; and it becomes index into chunky
3351 6347 0A                    asl   a                        ; buffer
3352 6348 A8                    tay                            ; Now back to Y
3353 6349 8A                    txa                            ; get what to store back from x
3354 634A 97 4C                 sta   [ScanMaskRef],y          ; store it
3355 634C C8                    iny   
3356 634D C8                    iny   
3357 634E 68                    pla   
3358 634F 97 4C                 sta   [ScanMaskRef],y
3359 6351 68                    pla                            ; now get original merged word off stack
3360 6352 EB                    xba                            ; get the high byte in low
3361 6353 29 FF 00              and   #$00FF                   ; and now we'll work with it
3362 6356 0A                    asl   a                        ; Quadruple so it is index into
3363 6357 0A                    asl   a                        ; conversion table
3364 6358 AA                    tax   
3365 6359 BF 74 63 FE           lda   >ConTable320+2,x
3366 635D 48                    pha   
3367 635E BF 72 63 FE           lda   >ConTable320,x
3368 6362 C8                    iny                            ; bump y so it points to new word in
3369 6363 C8                    iny                            ; chunky buffer
3370 6364 97 4C                 sta   [ScanMaskRef],y          ; store it
3371 6366 C8                    iny   
3372 6367 C8                    iny   
3373 6368 68                    pla   
3374 6369 97 4C                 sta   [ScanMaskRef],y
3375 636B C8                    iny                            ; bump 2 more times so after div by 4
3376 636C C8                    iny                            ; index to 1-bit is bumped twice.
3377 636D 98                    tya                            ; quarter index so can point to small
3378 636E 4A                    lsr   a                        ; buffer again.
3379 636F 4A                    lsr   a
3380 6370 A8                    tay   
3381 6371 60                    rts   
3382 6372
3383 6372                       ENDP 
3384 6372              ;                copy regions/table.320
3385 6372                       EXPORT ConTable320 
3386 6372              ConTable320 PROC 
3387 6372 00 00 00 00           DC B:$00,$00,$00,$00           ; 00000000
3388 6376 00 00 00 0F           DC B:$00,$00,$00,$0F           ; 00000001
3389 637A 00 00 00 F0           DC B:$00,$00,$00,$F0           ; 00000010
3390 637E 00 00 00 FF           DC B:$00,$00,$00,$FF           ; 00000011
3391 6382 00 00 0F 00           DC B:$00,$00,$0F,$00           ; 00000100
3392 6386 00 00 0F 0F           DC B:$00,$00,$0F,$0F           ; 00000101
3393 638A 00 00 0F F0           DC B:$00,$00,$0F,$F0           ; 00000110
3394 638E 00 00 0F FF           DC B:$00,$00,$0F,$FF           ; 00000111
3395 6392 00 00 F0 00           DC B:$00,$00,$F0,$00           ; 00001000
3396 6396 00 00 F0 0F           DC B:$00,$00,$F0,$0F           ; 00001001
3397 639A 00 00 F0 F0           DC B:$00,$00,$F0,$F0           ; 00001010
3398 639E 00 00 F0 FF           DC B:$00,$00,$F0,$FF           ; 00001011
3399 63A2 00 00 FF 00           DC B:$00,$00,$FF,$00           ; 00001100
3400 63A6 00 00 FF 0F           DC B:$00,$00,$FF,$0F           ; 00001101
3401 63AA 00 00 FF F0           DC B:$00,$00,$FF,$F0           ; 00001110
3402 63AE 00 00 FF FF           DC B:$00,$00,$FF,$FF           ; 00001111
3403 63B2 00 0F 00 00           DC B:$00,$0F,$00,$00           ; 00010000
3404 63B6 00 0F 00 0F           DC B:$00,$0F,$00,$0F           ; 00010001
3405 63BA 00 0F 00 F0           DC B:$00,$0F,$00,$F0           ; 00010010
3406 63BE 00 0F 00 FF           DC B:$00,$0F,$00,$FF           ; 00010011
3407 63C2 00 0F 0F 00           DC B:$00,$0F,$0F,$00           ; 00010100
3408 63C6 00 0F 0F 0F           DC B:$00,$0F,$0F,$0F           ; 00010101
3409 63CA 00 0F 0F F0           DC B:$00,$0F,$0F,$F0           ; 00010110
3410 63CE 00 0F 0F FF           DC B:$00,$0F,$0F,$FF           ; 00010111
3411 63D2 00 0F F0 00           DC B:$00,$0F,$F0,$00           ; 00011000
3412 63D6 00 0F F0 0F           DC B:$00,$0F,$F0,$0F           ; 00011001
3413 63DA 00 0F F0 F0           DC B:$00,$0F,$F0,$F0           ; 00011010
3414 63DE 00 0F F0 FF           DC B:$00,$0F,$F0,$FF           ; 00011011
3415 63E2 00 0F FF 00           DC B:$00,$0F,$FF,$00           ; 00011100
3416 63E6 00 0F FF 0F           DC B:$00,$0F,$FF,$0F           ; 00011101
3417 63EA 00 0F FF F0           DC B:$00,$0F,$FF,$F0           ; 00011110
3418 63EE 00 0F FF FF           DC B:$00,$0F,$FF,$FF           ; 00011111
3419 63F2 00 F0 00 00           DC B:$00,$F0,$00,$00           ; 00100000
3420 63F6 00 F0 00 0F           DC B:$00,$F0,$00,$0F           ; 00100001
3421 63FA 00 F0 00 F0           DC B:$00,$F0,$00,$F0           ; 00100010
3422 63FE 00 F0 00 FF           DC B:$00,$F0,$00,$FF           ; 00100011
3423 6402 00 F0 0F 00           DC B:$00,$F0,$0F,$00           ; 00100100
3424 6406 00 F0 0F 0F           DC B:$00,$F0,$0F,$0F           ; 00100101
3425 640A 00 F0 0F F0           DC B:$00,$F0,$0F,$F0           ; 00100110
3426 640E 00 F0 0F FF           DC B:$00,$F0,$0F,$FF           ; 00100111
3427 6412 00 F0 F0 00           DC B:$00,$F0,$F0,$00           ; 00101000
3428 6416 00 F0 F0 0F           DC B:$00,$F0,$F0,$0F           ; 00101001
3429 641A 00 F0 F0 F0           DC B:$00,$F0,$F0,$F0           ; 00101010
3430 641E 00 F0 F0 FF           DC B:$00,$F0,$F0,$FF           ; 00101011
3431 6422 00 F0 FF 00           DC B:$00,$F0,$FF,$00           ; 00101100
3432 6426 00 F0 FF 0F           DC B:$00,$F0,$FF,$0F           ; 00101101
3433 642A 00 F0 FF F0           DC B:$00,$F0,$FF,$F0           ; 00101110
3434 642E 00 F0 FF FF           DC B:$00,$F0,$FF,$FF           ; 00101111
3435 6432 00 FF 00 00           DC B:$00,$FF,$00,$00           ; 00110000
3436 6436 00 FF 00 0F           DC B:$00,$FF,$00,$0F           ; 00110001
3437 643A 00 FF 00 F0           DC B:$00,$FF,$00,$F0           ; 00110010
3438 643E 00 FF 00 FF           DC B:$00,$FF,$00,$FF           ; 00110011
3439 6442 00 FF 0F 00           DC B:$00,$FF,$0F,$00           ; 00110100
3440 6446 00 FF 0F 0F           DC B:$00,$FF,$0F,$0F           ; 00110101
3441 644A 00 FF 0F F0           DC B:$00,$FF,$0F,$F0           ; 00110110
3442 644E 00 FF 0F FF           DC B:$00,$FF,$0F,$FF           ; 00110111
3443 6452 00 FF F0 00           DC B:$00,$FF,$F0,$00           ; 00111000
3444 6456 00 FF F0 0F           DC B:$00,$FF,$F0,$0F           ; 00111001
3445 645A 00 FF F0 F0           DC B:$00,$FF,$F0,$F0           ; 00111010
3446 645E 00 FF F0 FF           DC B:$00,$FF,$F0,$FF           ; 00111011
3447 6462 00 FF FF 00           DC B:$00,$FF,$FF,$00           ; 00111100
3448 6466 00 FF FF 0F           DC B:$00,$FF,$FF,$0F           ; 00111101
3449 646A 00 FF FF F0           DC B:$00,$FF,$FF,$F0           ; 00111110
3450 646E 00 FF FF FF           DC B:$00,$FF,$FF,$FF           ; 00111111
3451 6472 0F 00 00 00           DC B:$0F,$00,$00,$00           ; 01000000
3452 6476 0F 00 00 0F           DC B:$0F,$00,$00,$0F           ; 01000001
3453 647A 0F 00 00 F0           DC B:$0F,$00,$00,$F0           ; 01000010
3454 647E 0F 00 00 FF           DC B:$0F,$00,$00,$FF           ; 01000011
3455 6482 0F 00 0F 00           DC B:$0F,$00,$0F,$00           ; 01000100
3456 6486 0F 00 0F 0F           DC B:$0F,$00,$0F,$0F           ; 01000101
3457 648A 0F 00 0F F0           DC B:$0F,$00,$0F,$F0           ; 01000110
3458 648E 0F 00 0F FF           DC B:$0F,$00,$0F,$FF           ; 01000111
3459 6492 0F 00 F0 00           DC B:$0F,$00,$F0,$00           ; 01001000
3460 6496 0F 00 F0 0F           DC B:$0F,$00,$F0,$0F           ; 01001001
3461 649A 0F 00 F0 F0           DC B:$0F,$00,$F0,$F0           ; 01001010
3462 649E 0F 00 F0 FF           DC B:$0F,$00,$F0,$FF           ; 01001011
3463 64A2 0F 00 FF 00           DC B:$0F,$00,$FF,$00           ; 01001100
3464 64A6 0F 00 FF 0F           DC B:$0F,$00,$FF,$0F           ; 01001101
3465 64AA 0F 00 FF F0           DC B:$0F,$00,$FF,$F0           ; 01001110
3466 64AE 0F 00 FF FF           DC B:$0F,$00,$FF,$FF           ; 01001111
3467 64B2 0F 0F 00 00           DC B:$0F,$0F,$00,$00           ; 01010000
3468 64B6 0F 0F 00 0F           DC B:$0F,$0F,$00,$0F           ; 01010001
3469 64BA 0F 0F 00 F0           DC B:$0F,$0F,$00,$F0           ; 01010010
3470 64BE 0F 0F 00 FF           DC B:$0F,$0F,$00,$FF           ; 01010011
3471 64C2 0F 0F 0F 00           DC B:$0F,$0F,$0F,$00           ; 01010100
3472 64C6 0F 0F 0F 0F           DC B:$0F,$0F,$0F,$0F           ; 01010101
3473 64CA 0F 0F 0F F0           DC B:$0F,$0F,$0F,$F0           ; 01010110
3474 64CE 0F 0F 0F FF           DC B:$0F,$0F,$0F,$FF           ; 01010111
3475 64D2 0F 0F F0 00           DC B:$0F,$0F,$F0,$00           ; 01011000
3476 64D6 0F 0F F0 0F           DC B:$0F,$0F,$F0,$0F           ; 01011001
3477 64DA 0F 0F F0 F0           DC B:$0F,$0F,$F0,$F0           ; 01011010
3478 64DE 0F 0F F0 FF           DC B:$0F,$0F,$F0,$FF           ; 01011011
3479 64E2 0F 0F FF 00           DC B:$0F,$0F,$FF,$00           ; 01011100
3480 64E6 0F 0F FF 0F           DC B:$0F,$0F,$FF,$0F           ; 01011101
3481 64EA 0F 0F FF F0           DC B:$0F,$0F,$FF,$F0           ; 01011110
3482 64EE 0F 0F FF FF           DC B:$0F,$0F,$FF,$FF           ; 01011111
3483 64F2 0F F0 00 00           DC B:$0F,$F0,$00,$00           ; 01100000
3484 64F6 0F F0 00 0F           DC B:$0F,$F0,$00,$0F           ; 01100001
3485 64FA 0F F0 00 F0           DC B:$0F,$F0,$00,$F0           ; 01100010
3486 64FE 0F F0 00 FF           DC B:$0F,$F0,$00,$FF           ; 01100011
3487 6502 0F F0 0F 00           DC B:$0F,$F0,$0F,$00           ; 01100100
3488 6506 0F F0 0F 0F           DC B:$0F,$F0,$0F,$0F           ; 01100101
3489 650A 0F F0 0F F0           DC B:$0F,$F0,$0F,$F0           ; 01100110
3490 650E 0F F0 0F FF           DC B:$0F,$F0,$0F,$FF           ; 01100111
3491 6512 0F F0 F0 00           DC B:$0F,$F0,$F0,$00           ; 01101000
3492 6516 0F F0 F0 0F           DC B:$0F,$F0,$F0,$0F           ; 01101001
3493 651A 0F F0 F0 F0           DC B:$0F,$F0,$F0,$F0           ; 01101010
3494 651E 0F F0 F0 FF           DC B:$0F,$F0,$F0,$FF           ; 01101011
3495 6522 0F F0 FF 00           DC B:$0F,$F0,$FF,$00           ; 01101100
3496 6526 0F F0 FF 0F           DC B:$0F,$F0,$FF,$0F           ; 01101101
3497 652A 0F F0 FF F0           DC B:$0F,$F0,$FF,$F0           ; 01101110
3498 652E 0F F0 FF FF           DC B:$0F,$F0,$FF,$FF           ; 01101111
3499 6532 0F FF 00 00           DC B:$0F,$FF,$00,$00           ; 01110000
3500 6536 0F FF 00 0F           DC B:$0F,$FF,$00,$0F           ; 01110001
3501 653A 0F FF 00 F0           DC B:$0F,$FF,$00,$F0           ; 01110010
3502 653E 0F FF 00 FF           DC B:$0F,$FF,$00,$FF           ; 01110011
3503 6542 0F FF 0F 00           DC B:$0F,$FF,$0F,$00           ; 01110100
3504 6546 0F FF 0F 0F           DC B:$0F,$FF,$0F,$0F           ; 01110101
3505 654A 0F FF 0F F0           DC B:$0F,$FF,$0F,$F0           ; 01110110
3506 654E 0F FF 0F FF           DC B:$0F,$FF,$0F,$FF           ; 01110111
3507 6552 0F FF F0 00           DC B:$0F,$FF,$F0,$00           ; 01111000
3508 6556 0F FF F0 0F           DC B:$0F,$FF,$F0,$0F           ; 01111001
3509 655A 0F FF F0 F0           DC B:$0F,$FF,$F0,$F0           ; 01111010
3510 655E 0F FF F0 FF           DC B:$0F,$FF,$F0,$FF           ; 01111011
3511 6562 0F FF FF 00           DC B:$0F,$FF,$FF,$00           ; 01111100
3512 6566 0F FF FF 0F           DC B:$0F,$FF,$FF,$0F           ; 01111101
3513 656A 0F FF FF F0           DC B:$0F,$FF,$FF,$F0           ; 01111110
3514 656E 0F FF FF FF           DC B:$0F,$FF,$FF,$FF           ; 01111111
3515 6572 F0 00 00 00           DC B:$F0,$00,$00,$00           ; 10000000
3516 6576 F0 00 00 0F           DC B:$F0,$00,$00,$0F           ; 10000001
3517 657A F0 00 00 F0           DC B:$F0,$00,$00,$F0           ; 10000010
3518 657E F0 00 00 FF           DC B:$F0,$00,$00,$FF           ; 10000011
3519 6582 F0 00 0F 00           DC B:$F0,$00,$0F,$00           ; 10000100
3520 6586 F0 00 0F 0F           DC B:$F0,$00,$0F,$0F           ; 10000101
3521 658A F0 00 0F F0           DC B:$F0,$00,$0F,$F0           ; 10000110
3522 658E F0 00 0F FF           DC B:$F0,$00,$0F,$FF           ; 10000111
3523 6592 F0 00 F0 00           DC B:$F0,$00,$F0,$00           ; 10001000
3524 6596 F0 00 F0 0F           DC B:$F0,$00,$F0,$0F           ; 10001001
3525 659A F0 00 F0 F0           DC B:$F0,$00,$F0,$F0           ; 10001010
3526 659E F0 00 F0 FF           DC B:$F0,$00,$F0,$FF           ; 10001011
3527 65A2 F0 00 FF 00           DC B:$F0,$00,$FF,$00           ; 10001100
3528 65A6 F0 00 FF 0F           DC B:$F0,$00,$FF,$0F           ; 10001101
3529 65AA F0 00 FF F0           DC B:$F0,$00,$FF,$F0           ; 10001110
3530 65AE F0 00 FF FF           DC B:$F0,$00,$FF,$FF           ; 10001111
3531 65B2 F0 0F 00 00           DC B:$F0,$0F,$00,$00           ; 10010000
3532 65B6 F0 0F 00 0F           DC B:$F0,$0F,$00,$0F           ; 10010001
3533 65BA F0 0F 00 F0           DC B:$F0,$0F,$00,$F0           ; 10010010
3534 65BE F0 0F 00 FF           DC B:$F0,$0F,$00,$FF           ; 10010011
3535 65C2 F0 0F 0F 00           DC B:$F0,$0F,$0F,$00           ; 10010100
3536 65C6 F0 0F 0F 0F           DC B:$F0,$0F,$0F,$0F           ; 10010101
3537 65CA F0 0F 0F F0           DC B:$F0,$0F,$0F,$F0           ; 10010110
3538 65CE F0 0F 0F FF           DC B:$F0,$0F,$0F,$FF           ; 10010111
3539 65D2 F0 0F F0 00           DC B:$F0,$0F,$F0,$00           ; 10011000
3540 65D6 F0 0F F0 0F           DC B:$F0,$0F,$F0,$0F           ; 10011001
3541 65DA F0 0F F0 F0           DC B:$F0,$0F,$F0,$F0           ; 10011010
3542 65DE F0 0F F0 FF           DC B:$F0,$0F,$F0,$FF           ; 10011011
3543 65E2 F0 0F FF 00           DC B:$F0,$0F,$FF,$00           ; 10011100
3544 65E6 F0 0F FF 0F           DC B:$F0,$0F,$FF,$0F           ; 10011101
3545 65EA F0 0F FF F0           DC B:$F0,$0F,$FF,$F0           ; 10011110
3546 65EE F0 0F FF FF           DC B:$F0,$0F,$FF,$FF           ; 10011111
3547 65F2 F0 F0 00 00           DC B:$F0,$F0,$00,$00           ; 10100000
3548 65F6 F0 F0 00 0F           DC B:$F0,$F0,$00,$0F           ; 10100001
3549 65FA F0 F0 00 F0           DC B:$F0,$F0,$00,$F0           ; 10100010
3550 65FE F0 F0 00 FF           DC B:$F0,$F0,$00,$FF           ; 10100011
3551 6602 F0 F0 0F 00           DC B:$F0,$F0,$0F,$00           ; 10100100
3552 6606 F0 F0 0F 0F           DC B:$F0,$F0,$0F,$0F           ; 10100101
3553 660A F0 F0 0F F0           DC B:$F0,$F0,$0F,$F0           ; 10100110
3554 660E F0 F0 0F FF           DC B:$F0,$F0,$0F,$FF           ; 10100111
3555 6612 F0 F0 F0 00           DC B:$F0,$F0,$F0,$00           ; 10101000
3556 6616 F0 F0 F0 0F           DC B:$F0,$F0,$F0,$0F           ; 10101001
3557 661A F0 F0 F0 F0           DC B:$F0,$F0,$F0,$F0           ; 10101010
3558 661E F0 F0 F0 FF           DC B:$F0,$F0,$F0,$FF           ; 10101011
3559 6622 F0 F0 FF 00           DC B:$F0,$F0,$FF,$00           ; 10101100
3560 6626 F0 F0 FF 0F           DC B:$F0,$F0,$FF,$0F           ; 10101101
3561 662A F0 F0 FF F0           DC B:$F0,$F0,$FF,$F0           ; 10101110
3562 662E F0 F0 FF FF           DC B:$F0,$F0,$FF,$FF           ; 10101111
3563 6632 F0 FF 00 00           DC B:$F0,$FF,$00,$00           ; 10110000
3564 6636 F0 FF 00 0F           DC B:$F0,$FF,$00,$0F           ; 10110001
3565 663A F0 FF 00 F0           DC B:$F0,$FF,$00,$F0           ; 10110010
3566 663E F0 FF 00 FF           DC B:$F0,$FF,$00,$FF           ; 10110011
3567 6642 F0 FF 0F 00           DC B:$F0,$FF,$0F,$00           ; 10110100
3568 6646 F0 FF 0F 0F           DC B:$F0,$FF,$0F,$0F           ; 10110101
3569 664A F0 FF 0F F0           DC B:$F0,$FF,$0F,$F0           ; 10110110
3570 664E F0 FF 0F FF           DC B:$F0,$FF,$0F,$FF           ; 10110111
3571 6652 F0 FF F0 00           DC B:$F0,$FF,$F0,$00           ; 10111000
3572 6656 F0 FF F0 0F           DC B:$F0,$FF,$F0,$0F           ; 10111001
3573 665A F0 FF F0 F0           DC B:$F0,$FF,$F0,$F0           ; 10111010
3574 665E F0 FF F0 FF           DC B:$F0,$FF,$F0,$FF           ; 10111011
3575 6662 F0 FF FF 00           DC B:$F0,$FF,$FF,$00           ; 10111100
3576 6666 F0 FF FF 0F           DC B:$F0,$FF,$FF,$0F           ; 10111101
3577 666A F0 FF FF F0           DC B:$F0,$FF,$FF,$F0           ; 10111110
3578 666E F0 FF FF FF           DC B:$F0,$FF,$FF,$FF           ; 10111111
3579 6672 FF 00 00 00           DC B:$FF,$00,$00,$00           ; 11000000
3580 6676 FF 00 00 0F           DC B:$FF,$00,$00,$0F           ; 11000001
3581 667A FF 00 00 F0           DC B:$FF,$00,$00,$F0           ; 11000010
3582 667E FF 00 00 FF           DC B:$FF,$00,$00,$FF           ; 11000011
3583 6682 FF 00 0F 00           DC B:$FF,$00,$0F,$00           ; 11000100
3584 6686 FF 00 0F 0F           DC B:$FF,$00,$0F,$0F           ; 11000101
3585 668A FF 00 0F F0           DC B:$FF,$00,$0F,$F0           ; 11000110
3586 668E FF 00 0F FF           DC B:$FF,$00,$0F,$FF           ; 11000111
3587 6692 FF 00 F0 00           DC B:$FF,$00,$F0,$00           ; 11001000
3588 6696 FF 00 F0 0F           DC B:$FF,$00,$F0,$0F           ; 11001001
3589 669A FF 00 F0 F0           DC B:$FF,$00,$F0,$F0           ; 11001010
3590 669E FF 00 F0 FF           DC B:$FF,$00,$F0,$FF           ; 11001011
3591 66A2 FF 00 FF 00           DC B:$FF,$00,$FF,$00           ; 11001100
3592 66A6 FF 00 FF 0F           DC B:$FF,$00,$FF,$0F           ; 11001101
3593 66AA FF 00 FF F0           DC B:$FF,$00,$FF,$F0           ; 11001110
3594 66AE FF 00 FF FF           DC B:$FF,$00,$FF,$FF           ; 11001111
3595 66B2 FF 0F 00 00           DC B:$FF,$0F,$00,$00           ; 11010000
3596 66B6 FF 0F 00 0F           DC B:$FF,$0F,$00,$0F           ; 11010001
3597 66BA FF 0F 00 F0           DC B:$FF,$0F,$00,$F0           ; 11010010
3598 66BE FF 0F 00 FF           DC B:$FF,$0F,$00,$FF           ; 11010011
3599 66C2 FF 0F 0F 00           DC B:$FF,$0F,$0F,$00           ; 11010100
3600 66C6 FF 0F 0F 0F           DC B:$FF,$0F,$0F,$0F           ; 11010101
3601 66CA FF 0F 0F F0           DC B:$FF,$0F,$0F,$F0           ; 11010110
3602 66CE FF 0F 0F FF           DC B:$FF,$0F,$0F,$FF           ; 11010111
3603 66D2 FF 0F F0 00           DC B:$FF,$0F,$F0,$00           ; 11011000
3604 66D6 FF 0F F0 0F           DC B:$FF,$0F,$F0,$0F           ; 11011001
3605 66DA FF 0F F0 F0           DC B:$FF,$0F,$F0,$F0           ; 11011010
3606 66DE FF 0F F0 FF           DC B:$FF,$0F,$F0,$FF           ; 11011011
3607 66E2 FF 0F FF 00           DC B:$FF,$0F,$FF,$00           ; 11011100
3608 66E6 FF 0F FF 0F           DC B:$FF,$0F,$FF,$0F           ; 11011101
3609 66EA FF 0F FF F0           DC B:$FF,$0F,$FF,$F0           ; 11011110
3610 66EE FF 0F FF FF           DC B:$FF,$0F,$FF,$FF           ; 11011111
3611 66F2 FF F0 00 00           DC B:$FF,$F0,$00,$00           ; 11100000
3612 66F6 FF F0 00 0F           DC B:$FF,$F0,$00,$0F           ; 11100001
3613 66FA FF F0 00 F0           DC B:$FF,$F0,$00,$F0           ; 11100010
3614 66FE FF F0 00 FF           DC B:$FF,$F0,$00,$FF           ; 11100011
3615 6702 FF F0 0F 00           DC B:$FF,$F0,$0F,$00           ; 11100100
3616 6706 FF F0 0F 0F           DC B:$FF,$F0,$0F,$0F           ; 11100101
3617 670A FF F0 0F F0           DC B:$FF,$F0,$0F,$F0           ; 11100110
3618 670E FF F0 0F FF           DC B:$FF,$F0,$0F,$FF           ; 11100111
3619 6712 FF F0 F0 00           DC B:$FF,$F0,$F0,$00           ; 11101000
3620 6716 FF F0 F0 0F           DC B:$FF,$F0,$F0,$0F           ; 11101001
3621 671A FF F0 F0 F0           DC B:$FF,$F0,$F0,$F0           ; 11101010
3622 671E FF F0 F0 FF           DC B:$FF,$F0,$F0,$FF           ; 11101011
3623 6722 FF F0 FF 00           DC B:$FF,$F0,$FF,$00           ; 11101100
3624 6726 FF F0 FF 0F           DC B:$FF,$F0,$FF,$0F           ; 11101101
3625 672A FF F0 FF F0           DC B:$FF,$F0,$FF,$F0           ; 11101110
3626 672E FF F0 FF FF           DC B:$FF,$F0,$FF,$FF           ; 11101111
3627 6732 FF FF 00 00           DC B:$FF,$FF,$00,$00           ; 11110000
3628 6736 FF FF 00 0F           DC B:$FF,$FF,$00,$0F           ; 11110001
3629 673A FF FF 00 F0           DC B:$FF,$FF,$00,$F0           ; 11110010
3630 673E FF FF 00 FF           DC B:$FF,$FF,$00,$FF           ; 11110011
3631 6742 FF FF 0F 00           DC B:$FF,$FF,$0F,$00           ; 11110100
3632 6746 FF FF 0F 0F           DC B:$FF,$FF,$0F,$0F           ; 11110101
3633 674A FF FF 0F F0           DC B:$FF,$FF,$0F,$F0           ; 11110110
3634 674E FF FF 0F FF           DC B:$FF,$FF,$0F,$FF           ; 11110111
3635 6752 FF FF F0 00           DC B:$FF,$FF,$F0,$00           ; 11111000
3636 6756 FF FF F0 0F           DC B:$FF,$FF,$F0,$0F           ; 11111001
3637 675A FF FF F0 F0           DC B:$FF,$FF,$F0,$F0           ; 11111010
3638 675E FF FF F0 FF           DC B:$FF,$FF,$F0,$FF           ; 11111011
3639 6762 FF FF FF 00           DC B:$FF,$FF,$FF,$00           ; 11111100
3640 6766 FF FF FF 0F           DC B:$FF,$FF,$FF,$0F           ; 11111101
3641 676A FF FF FF F0           DC B:$FF,$FF,$FF,$F0           ; 11111110
3642 676E FF FF FF FF           DC B:$FF,$FF,$FF,$FF           ; 11111111
3643 6772                       ENDP 
3644 6772              ;                copy regions/table.640
3645 6772
3646 6772                       EXPORT ConTable640 
3647 6772              ConTable640 PROC 
3648 6772 00 00                 DC B:%00000000,%00000000       ; 00000000
3649 6774 00 03                 DC B:%00000000,%00000011       ; 00000001
3650 6776 00 0C                 DC B:%00000000,%00001100       ; 00000010
3651 6778 00 0F                 DC B:%00000000,%00001111       ; 00000011
3652 677A 00 30                 DC B:%00000000,%00110000       ; 00000100
3653 677C 00 33                 DC B:%00000000,%00110011       ; 00000101
3654 677E 00 3C                 DC B:%00000000,%00111100       ; 00000110
3655 6780 00 3F                 DC B:%00000000,%00111111       ; 00000111
3656 6782 00 C0                 DC B:%00000000,%11000000       ; 00001000
3657 6784 00 C3                 DC B:%00000000,%11000011       ; 00001001
3658 6786 00 CC                 DC B:%00000000,%11001100       ; 00001010
3659 6788 00 CF                 DC B:%00000000,%11001111       ; 00001011
3660 678A 00 F0                 DC B:%00000000,%11110000       ; 00001100
3661 678C 00 F3                 DC B:%00000000,%11110011       ; 00001101
3662 678E 00 FC                 DC B:%00000000,%11111100       ; 00001110
3663 6790 00 FF                 DC B:%00000000,%11111111       ; 00001111
3664 6792 03 00                 DC B:%00000011,%00000000       ; 00010000
3665 6794 03 03                 DC B:%00000011,%00000011       ; 00010001
3666 6796 03 0C                 DC B:%00000011,%00001100       ; 00010010
3667 6798 03 0F                 DC B:%00000011,%00001111       ; 00010011
3668 679A 03 30                 DC B:%00000011,%00110000       ; 00010100
3669 679C 03 33                 DC B:%00000011,%00110011       ; 00010101
3670 679E 03 3C                 DC B:%00000011,%00111100       ; 00010110
3671 67A0 03 3F                 DC B:%00000011,%00111111       ; 00010111
3672 67A2 03 C0                 DC B:%00000011,%11000000       ; 00011000
3673 67A4 03 C3                 DC B:%00000011,%11000011       ; 00011001
3674 67A6 03 CC                 DC B:%00000011,%11001100       ; 00011010
3675 67A8 03 CF                 DC B:%00000011,%11001111       ; 00011011
3676 67AA 03 F0                 DC B:%00000011,%11110000       ; 00011100
3677 67AC 03 F3                 DC B:%00000011,%11110011       ; 00011101
3678 67AE 03 FC                 DC B:%00000011,%11111100       ; 00011110
3679 67B0 03 FF                 DC B:%00000011,%11111111       ; 00011111
3680 67B2 0C 00                 DC B:%00001100,%00000000       ; 00100000
3681 67B4 0C 03                 DC B:%00001100,%00000011       ; 00100001
3682 67B6 0C 0C                 DC B:%00001100,%00001100       ; 00100010
3683 67B8 0C 0F                 DC B:%00001100,%00001111       ; 00100011
3684 67BA 0C 30                 DC B:%00001100,%00110000       ; 00100100
3685 67BC 0C 33                 DC B:%00001100,%00110011       ; 00100101
3686 67BE 0C 3C                 DC B:%00001100,%00111100       ; 00100110
3687 67C0 0C 3F                 DC B:%00001100,%00111111       ; 00100111
3688 67C2 0C C0                 DC B:%00001100,%11000000       ; 00101000
3689 67C4 0C C3                 DC B:%00001100,%11000011       ; 00101001
3690 67C6 0C CC                 DC B:%00001100,%11001100       ; 00101010
3691 67C8 0C CF                 DC B:%00001100,%11001111       ; 00101011
3692 67CA 0C F0                 DC B:%00001100,%11110000       ; 00101100
3693 67CC 0C F3                 DC B:%00001100,%11110011       ; 00101101
3694 67CE 0C FC                 DC B:%00001100,%11111100       ; 00101110
3695 67D0 0C FF                 DC B:%00001100,%11111111       ; 00101111
3696 67D2 0F 00                 DC B:%00001111,%00000000       ; 00110000
3697 67D4 0F 03                 DC B:%00001111,%00000011       ; 00110001
3698 67D6 0F 0C                 DC B:%00001111,%00001100       ; 00110010
3699 67D8 0F 0F                 DC B:%00001111,%00001111       ; 00110011
3700 67DA 0F 30                 DC B:%00001111,%00110000       ; 00110100
3701 67DC 0F 33                 DC B:%00001111,%00110011       ; 00110101
3702 67DE 0F 3C                 DC B:%00001111,%00111100       ; 00110110
3703 67E0 0F 3F                 DC B:%00001111,%00111111       ; 00110111
3704 67E2 0F C0                 DC B:%00001111,%11000000       ; 00111000
3705 67E4 0F C3                 DC B:%00001111,%11000011       ; 00111001
3706 67E6 0F CC                 DC B:%00001111,%11001100       ; 00111010
3707 67E8 0F CF                 DC B:%00001111,%11001111       ; 00111011
3708 67EA 0F F0                 DC B:%00001111,%11110000       ; 00111100
3709 67EC 0F F3                 DC B:%00001111,%11110011       ; 00111101
3710 67EE 0F FC                 DC B:%00001111,%11111100       ; 00111110
3711 67F0 0F FF                 DC B:%00001111,%11111111       ; 00111111
3712 67F2 30 00                 DC B:%00110000,%00000000       ; 01000000
3713 67F4 30 03                 DC B:%00110000,%00000011       ; 01000001
3714 67F6 30 0C                 DC B:%00110000,%00001100       ; 01000010
3715 67F8 30 0F                 DC B:%00110000,%00001111       ; 01000011
3716 67FA 30 30                 DC B:%00110000,%00110000       ; 01000100
3717 67FC 30 33                 DC B:%00110000,%00110011       ; 01000101
3718 67FE 30 3C                 DC B:%00110000,%00111100       ; 01000110
3719 6800 30 3F                 DC B:%00110000,%00111111       ; 01000111
3720 6802 30 C0                 DC B:%00110000,%11000000       ; 01001000
3721 6804 30 C3                 DC B:%00110000,%11000011       ; 01001001
3722 6806 30 CC                 DC B:%00110000,%11001100       ; 01001010
3723 6808 30 CF                 DC B:%00110000,%11001111       ; 01001011
3724 680A 30 F0                 DC B:%00110000,%11110000       ; 01001100
3725 680C 30 F3                 DC B:%00110000,%11110011       ; 01001101
3726 680E 30 FC                 DC B:%00110000,%11111100       ; 01001110
3727 6810 30 FF                 DC B:%00110000,%11111111       ; 01001111
3728 6812 33 00                 DC B:%00110011,%00000000       ; 01010000
3729 6814 33 03                 DC B:%00110011,%00000011       ; 01010001
3730 6816 33 0C                 DC B:%00110011,%00001100       ; 01010010
3731 6818 33 0F                 DC B:%00110011,%00001111       ; 01010011
3732 681A 33 30                 DC B:%00110011,%00110000       ; 01010100
3733 681C 33 33                 DC B:%00110011,%00110011       ; 01010101
3734 681E 33 3C                 DC B:%00110011,%00111100       ; 01010110
3735 6820 33 3F                 DC B:%00110011,%00111111       ; 01010111
3736 6822 33 C0                 DC B:%00110011,%11000000       ; 01011000
3737 6824 33 C3                 DC B:%00110011,%11000011       ; 01011001
3738 6826 33 CC                 DC B:%00110011,%11001100       ; 01011010
3739 6828 33 CF                 DC B:%00110011,%11001111       ; 01011011
3740 682A 33 F0                 DC B:%00110011,%11110000       ; 01011100
3741 682C 33 F3                 DC B:%00110011,%11110011       ; 01011101
3742 682E 33 FC                 DC B:%00110011,%11111100       ; 01011110
3743 6830 33 FF                 DC B:%00110011,%11111111       ; 01011111
3744 6832 3C 00                 DC B:%00111100,%00000000       ; 01100000
3745 6834 3C 03                 DC B:%00111100,%00000011       ; 01100001
3746 6836 3C 0C                 DC B:%00111100,%00001100       ; 01100010
3747 6838 3C 0F                 DC B:%00111100,%00001111       ; 01100011
3748 683A 3C 30                 DC B:%00111100,%00110000       ; 01100100
3749 683C 3C 33                 DC B:%00111100,%00110011       ; 01100101
3750 683E 3C 3C                 DC B:%00111100,%00111100       ; 01100110
3751 6840 3C 3F                 DC B:%00111100,%00111111       ; 01100111
3752 6842 3C C0                 DC B:%00111100,%11000000       ; 01101000
3753 6844 3C C3                 DC B:%00111100,%11000011       ; 01101001
3754 6846 3C CC                 DC B:%00111100,%11001100       ; 01101010
3755 6848 3C CF                 DC B:%00111100,%11001111       ; 01101011
3756 684A 3C F0                 DC B:%00111100,%11110000       ; 01101100
3757 684C 3C F3                 DC B:%00111100,%11110011       ; 01101101
3758 684E 3C FC                 DC B:%00111100,%11111100       ; 01101110
3759 6850 3C FF                 DC B:%00111100,%11111111       ; 01101111
3760 6852 3F 00                 DC B:%00111111,%00000000       ; 01110000
3761 6854 3F 03                 DC B:%00111111,%00000011       ; 01110001
3762 6856 3F 0C                 DC B:%00111111,%00001100       ; 01110010
3763 6858 3F 0F                 DC B:%00111111,%00001111       ; 01110011
3764 685A 3F 30                 DC B:%00111111,%00110000       ; 01110100
3765 685C 3F 33                 DC B:%00111111,%00110011       ; 01110101
3766 685E 3F 3C                 DC B:%00111111,%00111100       ; 01110110
3767 6860 3F 3F                 DC B:%00111111,%00111111       ; 01110111
3768 6862 3F C0                 DC B:%00111111,%11000000       ; 01111000
3769 6864 3F C3                 DC B:%00111111,%11000011       ; 01111001
3770 6866 3F CC                 DC B:%00111111,%11001100       ; 01111010
3771 6868 3F CF                 DC B:%00111111,%11001111       ; 01111011
3772 686A 3F F0                 DC B:%00111111,%11110000       ; 01111100
3773 686C 3F F3                 DC B:%00111111,%11110011       ; 01111101
3774 686E 3F FC                 DC B:%00111111,%11111100       ; 01111110
3775 6870 3F FF                 DC B:%00111111,%11111111       ; 01111111
3776 6872 C0 00                 DC B:%11000000,%00000000       ; 10000000
3777 6874 C0 03                 DC B:%11000000,%00000011       ; 10000001
3778 6876 C0 0C                 DC B:%11000000,%00001100       ; 10000010
3779 6878 C0 0F                 DC B:%11000000,%00001111       ; 10000011
3780 687A C0 30                 DC B:%11000000,%00110000       ; 10000100
3781 687C C0 33                 DC B:%11000000,%00110011       ; 10000101
3782 687E C0 3C                 DC B:%11000000,%00111100       ; 10000110
3783 6880 C0 3F                 DC B:%11000000,%00111111       ; 10000111
3784 6882 C0 C0                 DC B:%11000000,%11000000       ; 10001000
3785 6884 C0 C3                 DC B:%11000000,%11000011       ; 10001001
3786 6886 C0 CC                 DC B:%11000000,%11001100       ; 10001010
3787 6888 C0 CF                 DC B:%11000000,%11001111       ; 10001011
3788 688A C0 F0                 DC B:%11000000,%11110000       ; 10001100
3789 688C C0 F3                 DC B:%11000000,%11110011       ; 10001101
3790 688E C0 FC                 DC B:%11000000,%11111100       ; 10001110
3791 6890 C0 FF                 DC B:%11000000,%11111111       ; 10001111
3792 6892 C3 00                 DC B:%11000011,%00000000       ; 10010000
3793 6894 C3 03                 DC B:%11000011,%00000011       ; 10010001
3794 6896 C3 0C                 DC B:%11000011,%00001100       ; 10010010
3795 6898 C3 0F                 DC B:%11000011,%00001111       ; 10010011
3796 689A C3 30                 DC B:%11000011,%00110000       ; 10010100
3797 689C C3 33                 DC B:%11000011,%00110011       ; 10010101
3798 689E C3 3C                 DC B:%11000011,%00111100       ; 10010110
3799 68A0 C3 3F                 DC B:%11000011,%00111111       ; 10010111
3800 68A2 C3 C0                 DC B:%11000011,%11000000       ; 10011000
3801 68A4 C3 C3                 DC B:%11000011,%11000011       ; 10011001
3802 68A6 C3 CC                 DC B:%11000011,%11001100       ; 10011010
3803 68A8 C3 CF                 DC B:%11000011,%11001111       ; 10011011
3804 68AA C3 F0                 DC B:%11000011,%11110000       ; 10011100
3805 68AC C3 F3                 DC B:%11000011,%11110011       ; 10011101
3806 68AE C3 FC                 DC B:%11000011,%11111100       ; 10011110
3807 68B0 C3 FF                 DC B:%11000011,%11111111       ; 10011111
3808 68B2 CC 00                 DC B:%11001100,%00000000       ; 10100000
3809 68B4 CC 03                 DC B:%11001100,%00000011       ; 10100001
3810 68B6 CC 0C                 DC B:%11001100,%00001100       ; 10100010
3811 68B8 CC 0F                 DC B:%11001100,%00001111       ; 10100011
3812 68BA CC 30                 DC B:%11001100,%00110000       ; 10100100
3813 68BC CC 33                 DC B:%11001100,%00110011       ; 10100101
3814 68BE CC 3C                 DC B:%11001100,%00111100       ; 10100110
3815 68C0 CC 3F                 DC B:%11001100,%00111111       ; 10100111
3816 68C2 CC C0                 DC B:%11001100,%11000000       ; 10101000
3817 68C4 CC C3                 DC B:%11001100,%11000011       ; 10101001
3818 68C6 CC CC                 DC B:%11001100,%11001100       ; 10101010
3819 68C8 CC CF                 DC B:%11001100,%11001111       ; 10101011
3820 68CA CC F0                 DC B:%11001100,%11110000       ; 10101100
3821 68CC CC F3                 DC B:%11001100,%11110011       ; 10101101
3822 68CE CC FC                 DC B:%11001100,%11111100       ; 10101110
3823 68D0 CC FF                 DC B:%11001100,%11111111       ; 10101111
3824 68D2 CF 00                 DC B:%11001111,%00000000       ; 10110000
3825 68D4 CF 03                 DC B:%11001111,%00000011       ; 10110001
3826 68D6 CF 0C                 DC B:%11001111,%00001100       ; 10110010
3827 68D8 CF 0F                 DC B:%11001111,%00001111       ; 10110011
3828 68DA CF 30                 DC B:%11001111,%00110000       ; 10110100
3829 68DC CF 33                 DC B:%11001111,%00110011       ; 10110101
3830 68DE CF 3C                 DC B:%11001111,%00111100       ; 10110110
3831 68E0 CF 3F                 DC B:%11001111,%00111111       ; 10110111
3832 68E2 CF C0                 DC B:%11001111,%11000000       ; 10111000
3833 68E4 CF C3                 DC B:%11001111,%11000011       ; 10111001
3834 68E6 CF CC                 DC B:%11001111,%11001100       ; 10111010
3835 68E8 CF CF                 DC B:%11001111,%11001111       ; 10111011
3836 68EA CF F0                 DC B:%11001111,%11110000       ; 10111100
3837 68EC CF F3                 DC B:%11001111,%11110011       ; 10111101
3838 68EE CF FC                 DC B:%11001111,%11111100       ; 10111110
3839 68F0 CF FF                 DC B:%11001111,%11111111       ; 10111111
3840 68F2 F0 00                 DC B:%11110000,%00000000       ; 11000000
3841 68F4 F0 03                 DC B:%11110000,%00000011       ; 11000001
3842 68F6 F0 0C                 DC B:%11110000,%00001100       ; 11000010
3843 68F8 F0 0F                 DC B:%11110000,%00001111       ; 11000011
3844 68FA F0 30                 DC B:%11110000,%00110000       ; 11000100
3845 68FC F0 33                 DC B:%11110000,%00110011       ; 11000101
3846 68FE F0 3C                 DC B:%11110000,%00111100       ; 11000110
3847 6900 F0 3F                 DC B:%11110000,%00111111       ; 11000111
3848 6902 F0 C0                 DC B:%11110000,%11000000       ; 11001000
3849 6904 F0 C3                 DC B:%11110000,%11000011       ; 11001001
3850 6906 F0 CC                 DC B:%11110000,%11001100       ; 11001010
3851 6908 F0 CF                 DC B:%11110000,%11001111       ; 11001011
3852 690A F0 F0                 DC B:%11110000,%11110000       ; 11001100
3853 690C F0 F3                 DC B:%11110000,%11110011       ; 11001101
3854 690E F0 FC                 DC B:%11110000,%11111100       ; 11001110
3855 6910 F0 FF                 DC B:%11110000,%11111111       ; 11001111
3856 6912 F3 00                 DC B:%11110011,%00000000       ; 11010000
3857 6914 F3 03                 DC B:%11110011,%00000011       ; 11010001
3858 6916 F3 0C                 DC B:%11110011,%00001100       ; 11010010
3859 6918 F3 0F                 DC B:%11110011,%00001111       ; 11010011
3860 691A F3 30                 DC B:%11110011,%00110000       ; 11010100
3861 691C F3 33                 DC B:%11110011,%00110011       ; 11010101
3862 691E F3 3C                 DC B:%11110011,%00111100       ; 11010110
3863 6920 F3 3F                 DC B:%11110011,%00111111       ; 11010111
3864 6922 F3 C0                 DC B:%11110011,%11000000       ; 11011000
3865 6924 F3 C3                 DC B:%11110011,%11000011       ; 11011001
3866 6926 F3 CC                 DC B:%11110011,%11001100       ; 11011010
3867 6928 F3 CF                 DC B:%11110011,%11001111       ; 11011011
3868 692A F3 F0                 DC B:%11110011,%11110000       ; 11011100
3869 692C F3 F3                 DC B:%11110011,%11110011       ; 11011101
3870 692E F3 FC                 DC B:%11110011,%11111100       ; 11011110
3871 6930 F3 FF                 DC B:%11110011,%11111111       ; 11011111
3872 6932 FC 00                 DC B:%11111100,%00000000       ; 11100000
3873 6934 FC 03                 DC B:%11111100,%00000011       ; 11100001
3874 6936 FC 0C                 DC B:%11111100,%00001100       ; 11100010
3875 6938 FC 0F                 DC B:%11111100,%00001111       ; 11100011
3876 693A FC 30                 DC B:%11111100,%00110000       ; 11100100
3877 693C FC 33                 DC B:%11111100,%00110011       ; 11100101
3878 693E FC 3C                 DC B:%11111100,%00111100       ; 11100110
3879 6940 FC 3F                 DC B:%11111100,%00111111       ; 11100111
3880 6942 FC C0                 DC B:%11111100,%11000000       ; 11101000
3881 6944 FC C3                 DC B:%11111100,%11000011       ; 11101001
3882 6946 FC CC                 DC B:%11111100,%11001100       ; 11101010
3883 6948 FC CF                 DC B:%11111100,%11001111       ; 11101011
3884 694A FC F0                 DC B:%11111100,%11110000       ; 11101100
3885 694C FC F3                 DC B:%11111100,%11110011       ; 11101101
3886 694E FC FC                 DC B:%11111100,%11111100       ; 11101110
3887 6950 FC FF                 DC B:%11111100,%11111111       ; 11101111
3888 6952 FF 00                 DC B:%11111111,%00000000       ; 11110000
3889 6954 FF 03                 DC B:%11111111,%00000011       ; 11110001
3890 6956 FF 0C                 DC B:%11111111,%00001100       ; 11110010
3891 6958 FF 0F                 DC B:%11111111,%00001111       ; 11110011
3892 695A FF 30                 DC B:%11111111,%00110000       ; 11110100
3893 695C FF 33                 DC B:%11111111,%00110011       ; 11110101
3894 695E FF 3C                 DC B:%11111111,%00111100       ; 11110110
3895 6960 FF 3F                 DC B:%11111111,%00111111       ; 11110111
3896 6962 FF C0                 DC B:%11111111,%11000000       ; 11111000
3897 6964 FF C3                 DC B:%11111111,%11000011       ; 11111001
3898 6966 FF CC                 DC B:%11111111,%11001100       ; 11111010
3899 6968 FF CF                 DC B:%11111111,%11001111       ; 11111011
3900 696A FF F0                 DC B:%11111111,%11110000       ; 11111100
3901 696C FF F3                 DC B:%11111111,%11110011       ; 11111101
3902 696E FF FC                 DC B:%11111111,%11111100       ; 11111110
3903 6970 FF FF                 DC B:%11111111,%11111111       ; 11111111
3904 6972                       ENDP 
3905 6972
3906 6972
3907 6972                       END   
